% This program computes results for the Factor model reported in the paper "Comovement of Economic Activity During the Covid Recession" by D. Maroz, J. Stock, and M. Watson

clear all;
small = 1.0e-10;
big = 1.0e+5;                  
this_date = datestr(now,'yyyymmdd');

% Include current folder in path
p1 = path;
currentFolder = pwd;
pp = path(p1,currentFolder);

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
xlsxdir = 'xlsx/';
matdir = 'mat/';
figdir_all = 'fig_all_series/';

% Read and Transform Data
Read_and_Transform_Data;

% Descriptive Statistics for Number of Factors
Number_of_Factor_Statistics;

% Use PC to get in-sample factors, factor loadings, etc.
In_Sample_Factors_via_PC;

% Construct Out-of-sample F and Fitted values using OLS and MN
OOS_f;

% Construct Out-of-sample F and G Fitted values using OLS and MN
OOS_f_g;

% Save Values of Gam for Table
Save_Gamma_xlsx;

% Figures
% Time Series Quantile Plots .. Figures 1 and 2
Quantile_TS_plots;

% Scatter plots .. Figure 3
Scatter_plots;

% Plot G
Plot_G;

% Plot sigma(t)
Plot_sigma_t;

% TS Plots of Fitted and Actuals -- Figures in paper
TS_actual_fitted_plots;

% TS Plots of Fitted and Actuals -- All series
TS_actual_fitted_plots_all_series;

% Miscellaneous Numbers,etc. reported in Text
Misc_results;



