% This program computes results for the Factor model reported in the paper "Comovement of Economic Activity During the Covid Recession" by D. Maroz, J. Stock, and M. Watson
% This version used k = 2 factors .. a robustness check on the k=3 factor
% results reported in the paper 
clear all;
small = 1.0e-10;
big = 1.0e+5;                  
this_date = datestr(now,'yyyymmdd');

% Include current folder in path
p1 = path;
currentFolder = pwd;
pp = path(p1,currentFolder);

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
xlsxdir = 'xlsx/';
matdir = 'mat/';

% Read and Transform Data
Read_and_Transform_Data;

% Descriptive Statistics for Number of Factors
% Number_of_Factor_Statistics;

% Use PC to get in-sample factors, factor loadings, etc.
In_Sample_Factors_via_PC_2;

% Construct Out-of-sample F and Fitted values using OLS and MN
OOS_f;

% Construct Out-of-sample F and G Fitted values using OLS and MN
OOS_f_g;

% Save Values of Gam for Table
Save_Gamma_xlsx_2;

% Figures
% Time Series Quantile Plots .. Figures 1 and 2
% Quantile_TS_plots;

% Scatter plots .. Figure 3
Scatter_plots_2;

% Plot G
Plot_G_2;

% Plot sigma(t)
Plot_sigma_t_2;

% TS Plots of Fitted and Actuals 
TS_actual_fitted_plots_2;

% Miscellaneous Numbers,etc. reported in Text
% Misc_results;



