function Rslt = Get_Fred_Data(Series_File,Data_File,Data_File_sheet,n_series_series_file,n_series_data_file,n_codes_series_file,First_Obs,Last_Obs,nperiod,Sdesc_Prefix)
% Read in a particular Fred Data set
%  

[nobs,calvec,calds] = calendar_make(First_Obs,Last_Obs,nperiod);

% Read in Series Information
[~,Sname,~]=xlsread(Series_File,['A3:A' num2str(2+n_series_series_file)]);
[~,Sdesc,~]=xlsread(Series_File,['B3:B' num2str(2+n_series_series_file)]);
[~,Code_Desc,~] = xlsread(Series_File,['C2:' fixed_to_aa(2+n_codes_series_file) '2']);
Code_Desc = Code_Desc';
Code_Mat = xlsread(Series_File,['C3:' fixed_to_aa(2+n_codes_series_file) num2str(2+n_series_series_file)]);

% Read Data
[~,Dname,~]=xlsread(Data_File,Data_File_sheet,['B1:' fixed_to_aa(1+n_series_data_file) '1']);
Dname = Dname';
Data_Tmp = xlsread(Data_File,Data_File_sheet,['B2:' fixed_to_aa(1+n_series_data_file) num2str(1+nobs)]);

% Save Data, etc;
Data_Mat = NaN(nobs,n_series_series_file);
for i = 1:n_series_series_file;
    [~,j] = ismember(Sname(i),Dname);
    if j == 0
        Sname(i)
        'Not Found'
    else
        Data_Mat(:,i) = Data_Tmp(:,j);
    end
    tmp = char(Sdesc(i));
    tmp = [Sdesc_Prefix tmp];
    Sdesc(i) = {tmp};
end;

Rslt.Sname = Sname;
Rslt.Sdesc = Sdesc;
Rslt.Code_Mat = Code_Mat;
Rslt.Code_Desc = Code_Desc;
Rslt.Data_Mat = Data_Mat;
Rslt.calds = calds;
Rslt.calvec = calvec;

end

