% --- Parameters used for Esimation 
data_fac_est = sgn_data;   % NOT Sign Adjusted

% Calendar, sample, parameters
est_par.smpl_par.nfirst = First_Obs_est;        % start date
est_par.smpl_par.nlast  = Last_Obs_est;         % end date
est_par.smpl_par.calvec = calvec;               % calendar 
est_par.smpl_par.nper   = 12;                   % number of periods per year

% Factor analysis parameters
est_par.fac_par.nt_min                  = 20;     % min number of obs for any series used to est factors
est_par.lambda.nt_min                   = 40;     % min number of obs for any series used to estimate lamba, irfs, etc.
est_par.fac_par.tol                     = 10^-8;  % precision of factor estimation (scaled by by n*t)

% Restrictions on factor loadings to identify factors
est_par.fac_par.lambda_constraints_est  = 1;  % no constraints on lambda
est_par.fac_par.lambda_constraints_full = 1;  % no constraints on lambda

% VAR parameters for factors
est_par.var_par.nlag   = 4;    % number of lags
est_par.var_par.iconst = 1;    % include constant
est_par.var_par.icomp  = 2;    % compute companion form of model .. excluding constant

% yit equation parameters
est_par.n_uarlag = 4;          % number of arlags for uniqueness

% ROBUSTNESS .. USE 2 Factors
nfac = 2;
est_par.fac_par.nfac.unobserved = nfac;
est_par.fac_par.nfac.observed = 0;
est_par.fac_par.nfac.total = nfac;

fac_est_out = factor_estimation_ls_full(data_fac_est,Icode_vec,est_par);                  % estimation

