function Data_Set = Make_Data(Data_Set,A,First_Obs_fs,Last_Obs_fs,nperiod);
% Update Data Set
% Step 1 .. extract data and save over full-sample period

[nobs_fs,calvec_fs,calds_fs] = calendar_make(First_Obs_fs,Last_Obs_fs,nperiod);
calvec = A.calvec;
calds = A.calds;
% Get SMPLs for each Calendar
  if calvec(1) < calvec_fs(1)
      Fdate = calds_fs(1,:);
  else 
      Fdate = calds(1,:);
  end
  if calvec(end) < calvec_fs(end)
      Ldate = calds(end,:);
  else
      Ldate = calds_fs(end,:);
  end
  ismpl_fs = smpl(calvec_fs,Fdate,Ldate,nperiod);
  ismpl = smpl(calvec,Fdate,Ldate,nperiod);
  Data_Mat = A.Data_Mat;
  ns = size(Data_Mat,2);
  Data_Mat_FS = NaN(nobs_fs,ns);
  Data_Mat_FS(ismpl_fs==1,:)=Data_Mat(ismpl==1,:);

 Sdesc = A.Sdesc;
 Sname = A.Sname;
 Code_Desc=A.Code_Desc;
 [~,j]=ismember('TransCode',A.Code_Desc);
 Tcode_vec = A.Code_Mat(:,j);
 [~,j] = ismember('InclCode',A.Code_Desc);
 Icode_vec = A.Code_Mat(:,j);
 [~,j] = ismember('OutlierCode',A.Code_Desc);
 Ocode_vec = A.Code_Mat(:,j);
 
if size(Data_Set.Data_Mat,1) == 1
   Data_Set.Data_Mat = Data_Mat_FS;
   Data_Set.Sdesc = Sdesc;
   Data_Set.Sname = Sname;
   Data_Set.Tcode_vec = Tcode_vec;
   Data_Set.Icode_vec = Icode_vec;
   Data_Set.Ocode_vec = Ocode_vec;
else
   Data_Set.Data_Mat = [Data_Set.Data_Mat Data_Mat_FS];
   Data_Set.Sdesc = [Data_Set.Sdesc; Sdesc];
   Data_Set.Sname = [Data_Set.Sname;Sname];
   Data_Set.Tcode_vec = [Data_Set.Tcode_vec;Tcode_vec]; 
   Data_Set.Icode_vec = [Data_Set.Icode_vec;Icode_vec];  
   Data_Set.Ocode_vec = [Data_Set.Ocode_vec;Ocode_vec];  
end


end

