
% --- Parameters used for Esimation 
  % Calendar, sample, parameters
  nfirst = First_Obs_est;
  nlast = Last_Obs_est;
  est_par.smpl_par.nfirst = nfirst;         % start date
  est_par.smpl_par.nlast  = nlast;         % end date
  est_par.smpl_par.calvec = calvec;    % calendar 
  est_par.smpl_par.nper   = 12;                % number of periods per year

  % Factor analysis parameters
  est_par.fac_par.nt_min                  = 20;     % min number of obs for any series used to est factors
  est_par.fac_par.tol                     = 10^-8;  % precision of factor estimation (scaled by by n*t)

% VAR parameters for factors
est_par.var_par.nlag   = 4;    % number of lags

% Factor Parameters
nfac_max = 10;

% Extract Estimation Sample 

data_fac_est = sgn_data;   % NOT Sign Adjusted
est_data = data_fac_est(:,Icode_vec==1);    
est_namevec = Sname(Icode_vec==1);

% --- Full Sample Results ---
% Compute Various Statistics for estimating the number of static and dynamic factors
nfac_out = est_nfac_bn(est_data,nfac_max,est_par);

% Summarize and save results
outfile_name = [outdir 'nfac_' num2str(nfirst(1)) '_' num2str(nlast(1)) '.out'];
fileID = fopen(outfile_name,'w');


% Static factors
kvec = (1:nfac_max)';
trace_r2 = ones(nfac_max,1)- nfac_out.st.ssr/nfac_out.st.tss;
marg_r2 = NaN*ones(nfac_max,1);
marg_r2(1) = trace_r2(1);
marg_r2(2:end) = trace_r2(2:end)-trace_r2(1:end-1);
ah_er = NaN(nfac_max,1);
ah_er(1:nfac_max-1) = marg_r2(1:nfac_max-1)./marg_r2(2:nfac_max);
fprintf(fileID,'Descriptive Statistics for determining the number of factors \n\n');
fprintf(fileID,'  Sample Period: %4i:Q%1i',est_par.smpl_par.nfirst);
fprintf(fileID,'-%4i:Q%1i\n',est_par.smpl_par.nlast);
fprintf(fileID,'  Static factor statistics\n');
fprintf(fileID,'    Nobs = %8i \n',nfac_out.st.nobs);
fprintf(fileID,'    Nbar = %5.2f \n',(nfac_out.st.nobs/nfac_out.st.nt));
fprintf(fileID,'K, trace R2, marginal r2, BN-ICP, AH-ER \n');
fprintf(fileID,'0,0,0,0\n');
for i = 1:nfac_max;
    fprintf(fileID,'%2i, ', kvec(i));
    fprintf(fileID,'%5.3f, ', trace_r2(i));
    fprintf(fileID,'%5.3f, ', marg_r2(i));
    fprintf(fileID,'%5.3f, ', nfac_out.st.bn(i));
    fprintf(fileID,'%5.3f \n', ah_er(i));
 end;
 
 % Save Marginal R2 for Scree plot
 save([matdir 'marg_r2_' num2str(nfirst(1)) '_' num2str(nlast(1))],'marg_r2');
 

