% Sub-aggregates
lam_mat = fac_est_out.lam_mat;         % Lambda in units of data input to factor_estimation program
n_s = sum(Icode_vec==1);
n_oos = sum(ismpl_oos);
lam = lam_mat(Icode_vec==1,:);


% Construct estimates of oos f
X = data_fac_est(:,Icode_vec==1);
factor_ols = NaN(dnobs,nfac);
factor_ols_var = NaN(dnobs,nfac,nfac);  % HR covariance matrix
factor_ols_se = NaN(dnobs,nfac);  % HR covariance matrix
for t = t_first_oos:dnobs
   [fols,vols,se_ols,r2_ols] = hac_ols(X(t,:)',lam,0,1);
   factor_ols(t,:) = fols';
   factor_ols_se(t,:) = se_ols';
   factor_ols_var(t,:,:)=vols;
end
factor_ols(ismpl_est==1,:)=fac_est_out.fac(ismpl_est==1,:);

% -- Estimate F in out-of-sample period using Bayes mixed normal model cross section of error
X = data_fac_est(ismpl_oos==1,Icode_vec==1);   % Data over out-of-sample period
T = size(X,1);
n_s = size(X,2);

% Note .. diffuse priors for sigma2 and f
% Prior for variance -- Marron-Wand Outlier Mixture
p_prior = 0.1;     % Outlier probability
sfac = 10;         % Standard deviation multiplier for outlier
ndf = n_s-nfac;

% Step 3: Number of reps .. matrices for saving things, etc.
nrep = 5000;
nburnin = 2000;
f_save = NaN(nrep,T,nfac);
sigma_save = NaN(nrep,T);
frac_outlier = NaN(nrep,T);

% Carry out analysis date-by-date
for t = 1:T
    y = X(t,:)';
    % initial values
    f = inv(lam'*lam)*lam'*y;
    u = y - lam*f;
    sigma2 = mean(u.^2);
    ind_out = zeros(n_s,1);  % Outlier Indicator
    for irep = 1:nburnin+nrep
        wght = ones(n_s,1);
        wght(ind_out==1) = 1/sfac;
        yw = y.*wght;
        xw = lam.*repmat(wght,1,nfac);
        fmean = xw\yw;
        fvar = sigma2*inv(xw'*xw);
        fvar_sqrt = sqrt_psd(fvar);
        fdraw = fmean + fvar_sqrt*randn(nfac,1);
        uwhat = yw-xw*fmean;
        ssr = sum(uwhat.^2);
        sigma2=ssr/chi2rnd(ndf);
        sigma = sqrt(sigma2);
        % Get new weights
        u = y - lam*fdraw;
        f0 = normpdf(u,0,sigma);
        f1 = normpdf(u,0,sfac*sigma);
        p_post = (p_prior*f1)./(p_prior*f1 + (1-p_prior)*f0);
        ind_out = rand(n_s,1) < p_post;
        if irep > nburnin
            kk = irep-nburnin;
            f_save(kk,t,:)=fdraw;
            sigma_save(kk,t) = sigma;
            frac_outlier(kk,t) = mean(ind_out);
        end   
    end
end

factor_mn = NaN(dnobs,nfac);
factor_mn(ismpl_est==1,:)=fac_est_out.fac(ismpl_est==1,:);
factor_mn(ismpl_oos==1,:)=squeeze(mean(f_save,1));
factor_mn_var = NaN(dnobs,nfac,nfac);  % HR covariance matrix
for t = 1:T
    f = squeeze(f_save(:,t,:));
    fmean = mean(f);
    ff = f'*f/nrep;
    factor_mn_var(t+t_last_est,:,:) = ff-fmean'*fmean;
end

% Fitted Values
Xfit_f_ols = factor_ols*lam_mat';
Xfit_f_mn = factor_mn*lam_mat';