% Construct Factors using in-sample lambda's and actual out-of-sample data
lam_mat = fac_est_out.lam_mat;         % Lambda in units of data input to factor_estimation program

% Sub-aggregates
n_s = sum(Icode_vec==1);
n_oos = sum(ismpl_oos);
lam = lam_mat(Icode_vec==1,:);
x = data_fac_est(:,Icode_vec==1);

% Construct estimates of oos f
X = data_fac_est(:,Icode_vec==1);
factor_ols = NaN(dnobs,nfac);
factor_ols_var = NaN(dnobs,nfac,nfac);  % HR covariance matrix
factor_ols_se = NaN(dnobs,nfac);  % HR covariance matrix
for t = t_first_oos:dnobs
   [fols,vols,se_ols,r2_ols] = hac_ols(X(t,:)',lam,0,1);
   factor_ols(t,:) = fols';
   factor_ols_se(t,:) = se_ols';
   factor_ols_var(t,:,:)=vols;
end
factor_ols(ismpl_est==1,:)=fac_est_out.fac(ismpl_est==1,:);
	
% Construct Estimates of G
% ... Get out-of-sample data and estimate g
X = data_fac_est(ismpl_oos==1,Icode_vec==1);
XX = X'*X;
M = eye(size(XX,1))-lam*inv(lam'*lam)*lam';
XX = M*XX*M';
[V,D] = eig(XX);
d = real(diag(D));
[a,id]=sort(d,'descend');
gam = real(V(:,id(1)));
g = X*gam;     % New Factors in OOS period
% Scale g so it is equal to -1 in April 2020
scl_g = -g(2);
g = g/scl_g;
g_ols = zeros(dnobs,1);
g_ols(ismpl_oos==1,:)=g;
gam = gam*scl_g;
% Estimate lambda and gamma each series using standardized data;
Lam = NaN(n_series,nfac);
Gam = NaN(n_series,1);
for i = 1:n_series;
    x = factor_ols(ismpl_est==1,:);
    y = data_fac_est(ismpl_est==1,i);
    z = packr([y x]);
    y = z(:,1);
    x = z(:,2:end);
    Lam(i,:) = (inv(x'*x)*x'*y)';
    
    x = g_ols(ismpl_oos==1,:);
    y = data_fac_est(ismpl_oos==1,i)-factor_ols(ismpl_oos==1,:)*Lam(i,:)';
    z = packr([y x]);
    y = z(:,1);
    x = z(:,2:end);
    Gam(i,:) = (inv(x'*x)*x'*y)';  
end;
% Note GAM is produced by OLS without imposing lam'*gam=0 .. replace Gam
% for subaggregates which imposes the constraint
Gam_ols = Gam;
Gam_ols(Icode_vec==1)=gam;


% --- Carry out estimation using mixed normal outliers .. with time varying variances

% Step 1: Data
X = data_fac_est(ismpl_oos==1,Icode_vec==1);      % Data over out-of-sample period
Xagg = data_fac_est(ismpl_oos==1,Icode_vec==2);   % Aggregates
T = size(X,1);
n_agg = size(Xagg,2);
lam_agg = Lam(Icode_vec==2,:);

% Note .. diffuse priors for sigma2 and f
% Prior for variance -- Marron-Wand Outlier Mixture
p_prior = 0.1;     % Outlier probability
sfac = 10;         % Standard deviation multiplier for outlier
ndf = n_s-nfac;

% Step 3: Number of reps .. matrices for saving things, etc.
nrep = 5000;
nburnin = 2000;
f_save = NaN(nrep,T,nfac);
sigma_save = NaN(nrep,T);
g_save = NaN(nrep,T);
gam_save = NaN(nrep,n_s);
frac_outlier = NaN(nrep,T);
gam_agg_save = NaN(nrep,n_agg); 

% Use OLS values as initial values
gam = gam;
lam = lam;
f = factor_ols(ismpl_oos==1,:);
g = g_ols(ismpl_oos==1,:);
u = X - f*lam' - g*gam';
sigma_vec = sqrt(mean(u.^2,2));
ind_out_mat = zeros(T,n_s);

for irep = 1:nburnin+nrep
    % Compute f and g .. iterations over t
    for t = 1:T
        y = X(t,:)';
        ind_out = ind_out_mat(t,:)';
        sigma2 = sigma_vec(t)^2;
        wght = ones(n_s,1);
        wght(ind_out==1) = 1/sfac;
        if t ~= 2
         yw = y.*wght;
         x = [lam gam];
         xw = x.*repmat(wght,1,size(x,2));
         wmean = xw\yw;
         wvar = sigma2*inv(xw'*xw);
         wvar_sqrt = sqrt_psd(wvar);
         wdraw = wmean + wvar_sqrt*randn(length(wmean),1);
         fdraw = wdraw(1:end-1);
         gdraw = wdraw(end);
        else
         gdraw = g(2);
         yw = (y-gam*gdraw).*wght;
         x = lam;
         xw = x.*repmat(wght,1,size(x,2));
         wmean = xw\yw;
         wvar = sigma2*inv(xw'*xw);
         wvar_sqrt = sqrt_psd(wvar);
         wdraw = wmean + wvar_sqrt*randn(length(wmean),1);
         fdraw = wdraw(1:end);
        end
        uwhat = yw-xw*wmean;
        ssr = sum(uwhat.^2);
        sigma2=ssr/chi2rnd(size(xw,1)-size(xw,2));
        sigma = sqrt(sigma2);
        % Get new weights
        u = y - x*wdraw;
        f0 = normpdf(u,0,sigma);
        f1 = normpdf(u,0,sfac*sigma);
        p_post = (p_prior*f1)./(p_prior*f1 + (1-p_prior)*f0);
        ind_out = rand(n_s,1) < p_post;
        ind_out_mat(t,:) = ind_out';
        f(t,:) = fdraw';
        g(t) = gdraw;
        sigma_vec(t) = sigma;
    end
    bols = NaN(n_s,1);
    vols = zeros(n_s,n_s);
    for i = 1:n_s
        y = X(:,i)-f*lam(i,:)';
        x = g;
        ind_out = ind_out_mat(:,i);
        sigma = sigma_vec.*((ind_out==0) + sfac*(ind_out==1));
        wght = 1./sigma;
        yw = y.*wght;
        xw = x.*wght;
        bols(i) = xw\yw;
        vols(i,i) = inv(xw'*xw);   % Scale is 1 because wght divides by sigma
    end
    % Impose constraint lam'gam = 0
    R = eye(n_s)-vols*lam*(inv(lam'*vols*lam))*lam';
    wmean = R*bols;
    wvar = R*vols*R';
    wvar_sqrt = sqrt_psd(wvar);
    gam = wmean + wvar_sqrt*randn(length(wmean),1);
    % Construct an estimate of gamma for aggregates .. no outliers
    gam_agg = NaN(n_agg,1);
    for i = 1:n_agg
        y = Xagg(:,i)-f*lam_agg(i,:)';
        x = g;
        sigma = sigma_vec;
        wght = 1./sigma;
        yw = y.*wght;
        xw = x.*wght;
        wmean = xw\yw;
        wvar = inv(xw'*xw);   % Scale is 1 because wght divides by sigma
        wvar_sqrt = sqrt_psd(wvar);
        gam_agg(i) = wmean + wvar_sqrt*randn(length(wmean),1);
    end;
    if irep > nburnin
            kk = irep-nburnin;
            f_save(kk,:,:)=f;
            g_save(kk,:)=g';
            sigma_save(kk,:)=sigma_vec';
            gam_save(kk,:) = gam';
            gam_agg_save(kk,:) = gam_agg';
    end 
end

% Rearrange and Save Variables
Gam_mn_draws = NaN(nrep,n_series);
Gam_mn_draws(:,Icode_vec==1) = gam_save;
Gam_mn_draws(:,Icode_vec==2) = gam_agg_save;
Gam_mn_mean = mean(Gam_mn_draws)';
factor_mn_draws = NaN(nrep,dnobs,nfac);
for irep = 1:nrep
    factor_mn_draws(irep,ismpl_est==1,:)=factor_ols(ismpl_est==1,:);
end
factor_mn_draws(:,ismpl_oos==1,:) = f_save;
g_mn_draws = zeros(nrep,dnobs);
g_mn_draws(:,ismpl_oos==1) = g_save;

% Construct Actual and Fitted Values
Xfit_f_g_ols = factor_ols*Lam'+g_ols*Gam_ols';

Xfit_f_g_mn_draws = NaN(nrep,dnobs,n_series);
for irep = 1:nrep
    f = squeeze(factor_mn_draws(irep,:,:));
    g = g_mn_draws(irep,:)';
    gam = Gam_mn_draws(irep,:)';
    lam = Lam;
    Xfit_f_g_mn_draws(irep,:,:)=f*lam'+g*gam';
end

Xfit_f_g_mn = squeeze(mean(Xfit_f_g_mn_draws,1));  % Fitted Values using f and g
Gam_mn = Gam_mn_mean;
g_mn = mean(g_mn_draws,1)';
sigma_mean = sqrt(1-0.218)*ones(dnobs,1);   % 0.218 is the in-sample R2 using 3 factors and 89 series)
sigma_mean(ismpl_oos==1) = mean(sigma_save,1)';

% Compute pre-covid estimate of sigma
u_pre = data_fac_est(ismpl_est==1,Icode_vec==1) - Xfit_f_g_mn(ismpl_est==1,Icode_vec==1);
