% Compute Quantiles date-by-date
pct = [0.05 0.25 0.75 0.95 0.50];
data_pct = NaN(dnobs,5);
for t = 1:dnobs;
    x = packr(sgn_data(t,:)');
    if size(x,1) > 25
        tmp = pctile(x,pct);
        data_pct(t,:) = tmp';
    end
end;

% Save Quantiles for each date
T1 = table(calvec,data_pct);
fname = [xlsxdir 'Quantiles_Figure_1.xlsx'];
writetable(T1,fname);

% Values of the data in 2020:M4
ismpl_2020M4 = smpl(calvec,[2020 4],[2020 4],12);
data_2020M4 = data_fac_est(ismpl_2020M4==1,:)';
T2 = table(Sname,Sdesc,data_2020M4);
fname = [xlsxdir 'Data_2020M4.xlsx'];
writetable(T2,fname);


% Plot figure 1
leg_fs = 25;
ax_fs = 25;
fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
ismpl = ismpl_est;
plot(calvec(ismpl==1),data_pct(ismpl==1,:),'LineWidth',0.001)
hold on;
x = calvec(ismpl==1);
x2 = [x;flipud(x)];
z = [data_pct(ismpl==1,1);flipud(data_pct(ismpl==1,2))];
fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
z = [data_pct(ismpl==1,2);flipud(data_pct(ismpl==1,3))];
fill(x2,z,rgb('Red'),'EdgeColor','none');
z = [data_pct(ismpl==1,3);flipud(data_pct(ismpl==1,4))];
fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
hold off;
xlim([1955 2025]);
set(gca,'FontSize',ax_fs);
xlabel('Date','FontSize',ax_fs);
ylabel('Standard Deviations','FontSize',ax_fs);
figure_to_png(figdir, 'Q_Plot_1a');
close(fig);

fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
ismpl = smpl(calvec,[2019 1],Last_Obs_fs,nperiod);
plot(calvec(ismpl==1),data_pct(ismpl==1,:),'LineWidth',0.001)
hold on;
x = calvec(ismpl==1);
x2 = [x;flipud(x)];
z = [data_pct(ismpl==1,1);flipud(data_pct(ismpl==1,2))];
fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
z = [data_pct(ismpl==1,2);flipud(data_pct(ismpl==1,3))];
fill(x2,z,rgb('Red'),'EdgeColor','none');
z = [data_pct(ismpl==1,3);flipud(data_pct(ismpl==1,4))];
fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
hold off;
xlim([2019 2022]);
set(gca,'FontSize',ax_fs);
xlabel('Date','FontSize',ax_fs);
ylabel('Standard Deviations','FontSize',ax_fs);
figure_to_png(figdir, 'Q_Plot_1b');
close(fig);

% Figure 2
u = data_fac_est-Xfit_f_ols;
% Compute Quantiles date-by-date
u_pct = NaN(dnobs,5);
pct = [0.05 0.25 0.75 0.95 0.50];
for t = 1:dnobs;
    x = packr(u(t,:)');
    if size(x,1) > 25
        tmp = pctile(x,pct);
        u_pct(t,:) = tmp';
    end
end;

% Plot figure 1(a) ... Q plots, in-sample
leg_fs = 25;
ax_fs = 25;
fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
ismpl = ismpl_est;
plot(calvec(ismpl==1),u_pct(ismpl==1,:),'LineWidth',0.001)
hold on;
x = calvec(ismpl==1);
x2 = [x;flipud(x)];
z = [u_pct(ismpl==1,1);flipud(u_pct(ismpl==1,2))];
fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
z = [u_pct(ismpl==1,2);flipud(u_pct(ismpl==1,3))];
fill(x2,z,rgb('Red'),'EdgeColor','none');
z = [u_pct(ismpl==1,3);flipud(u_pct(ismpl==1,4))];
fill(x2,z,rgb('LightSalmon'),'EdgeColor','none');
hold off;
xlim([1955 2025]);
set(gca,'FontSize',ax_fs);
xlabel('Date','FontSize',ax_fs);
ylabel('Standard Deviations','FontSize',ax_fs);
figure_to_png(figdir, 'Q_Plot_2');
close(fig);