%  Set up calendar to for data
First_Obs_fs = [1959 1];
Last_Obs_fs = [2021 10];
nperiod = 12;  % Periods per year
[dnobs,calvec,calds]=calendar_make(First_Obs_fs,Last_Obs_fs,nperiod);
First_Obs_est = [1959 3];
Last_Obs_est = [2020 2];
ismpl_tmp = smpl(calvec,Last_Obs_est,Last_Obs_est,nperiod);
[~,t_last_est]=max(ismpl_tmp);
t_first_oos = t_last_est+1;
ismpl_est = smpl(calvec,First_Obs_est,Last_Obs_est,nperiod);
ismpl_oos = smpl(calvec,calds(t_first_oos,:),Last_Obs_fs,nperiod);

% Read in data series
i_first = 1;
data_in_fac;
n_series = size(Data_Mat,2);

% Transform data
ismpl_dm = smpl(calvec,First_Obs_fs,Last_Obs_est,nperiod);
bw_bw = 100;
io_method=4;    % Replacement of outliers
thr1=5;         % Threshold multiple for IQR ;
thr2=3;         % Threshold multiple for IQR ;

Data_raw = Data_Mat;
Data_tran = NaN(size(Data_raw));  
Data_tran_oa = NaN(size(Data_raw)); 
Data_tran_trend = NaN(size(Data_tran));
Data_tran_demean = NaN(size(Data_tran));
Data_tran_oa_demean = NaN(size(Data_tran));
Data_tran_oa_std = NaN(size(Data_tran));
Data_tran_std = NaN(size(Data_tran));


% Local mean ..'trend' is computed using OA data
sd_vec = NaN(n_series,1);
mean_vec = NaN(n_series,1);
for i = 1:n_series;    
    Data_tran(:,i) = transx(Data_raw(:,i),Tcode_vec(i));  
    Data_tran_oa(:,i) = Data_tran(:,i);
    Data_tran_oa(ismpl_dm==1,i) = adjout(Data_tran(ismpl_dm==1,i),thr1,io_method);
    
    tmp = bw_trend(Data_tran_oa(ismpl_dm==1,i),bw_bw);
    Data_tran_trend(ismpl_dm==1,i)= tmp;
    Data_tran_trend(t_first_oos:dnobs,i) = tmp(end)*ones(dnobs-t_first_oos+1,1);
    Data_tran_demean(:,i) = Data_tran(:,i) - Data_tran_trend(:,i);
    Data_tran_oa_demean(:,i) = Data_tran_oa(:,i) - Data_tran_trend(:,i);
    
    % Standardize using in-sample SD of OA series
    sd_vec(i) = std(packr(Data_tran_oa_demean(ismpl_est==1,i)));
    mean_vec(i) = mean(packr(Data_tran_oa_demean(ismpl_est==1,i)));
    Data_tran_std(:,i) = (Data_tran_demean(:,i)-mean_vec(i))/sd_vec(i);
    Data_tran_oa_std(:,i) = (Data_tran_oa_demean(:,i)-mean_vec(i))/sd_vec(i);
end;

% Local mean ..'trend' is computed using OA data
sd_vec = NaN(n_series,1);
mean_vec = NaN(n_series,1);
for i = 1:n_series   
    Data_tran(:,i) = transx(Data_raw(:,i),Tcode_vec(i));  
    Data_tran_oa(:,i) = Data_tran(:,i);
    Data_tran_oa(ismpl_dm==1,i) = adjout(Data_tran(ismpl_dm==1,i),thr1,io_method);
    
    tmp = bw_trend(Data_tran_oa(ismpl_dm==1,i),bw_bw);
    Data_tran_trend(ismpl_dm==1,i)= tmp;
    Data_tran_trend(t_first_oos:dnobs,i) = tmp(end)*ones(dnobs-t_first_oos+1,1);
    Data_tran_demean(:,i) = Data_tran(:,i) - Data_tran_trend(:,i);
    Data_tran_oa_demean(:,i) = Data_tran_oa(:,i) - Data_tran_trend(:,i);
    
    % Standardize using in-sample SD of OA series
    sd_vec(i) = std(packr(Data_tran_oa_demean(ismpl_est==1,i)));
    mean_vec(i) = mean(packr(Data_tran_oa_demean(ismpl_est==1,i)));
    Data_tran_std(:,i) = (Data_tran_demean(:,i)-mean_vec(i))/sd_vec(i);
    Data_tran_oa_std(:,i) = (Data_tran_oa_demean(:,i)-mean_vec(i))/sd_vec(i);
end

% Fix Sign so variables are procyclical
% Find IP
i_ip = ismember(Sname,'INDPRO');
xip = Data_tran_oa_std(:,i_ip==1);
sgn_procycl = NaN(n_series,1);
for i = 1:n_series;
    x = Data_tran_oa_std(:,i);
    z = [xip x];
    z = ma(z,12);
    z = z(ismpl_est==1,:);
    z = packr(z);
    zz = z(:,1)'*z(:,2);
    sgn_procycl(i) = (zz >= 0) - (zz < 0);
%     aa = char(Sdesc(i));
%     fprintf([aa ': %2i \n'],sgn_procycl(i));
end;

sgn_data = Data_tran_oa_std.*repmat(sgn_procycl',dnobs,1);