% In-sample 
leg_fs = 25;
ax_fs = 25;
marker_sz = 65; 

% In-sample
ismpl = smpl(calvec,First_Obs_est,Last_Obs_est,12);
Y = data_fac_est(ismpl==1,:);
lin45 = linspace(-10,10,500)';
fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
%subplot(2,2,1);
X = Xfit_f_ols(ismpl==1,:);
scatter(X,Y,marker_sz,'blue','filled');
hold on;
%plot(lin45,lin45,'- k','LineWidth',1);
hold off;
xlim([-8 8]);
ylim([-8 8]);
title('(a) 1959:M3 - 2020:M2','FontSize',ax_fs);
xlabel('Fitted Value','FontSize',ax_fs);
ylabel('Actual','FontSize',ax_fs);
set(gca,'FontSize',ax_fs);
tmp = packr([X(:) Y(:)]);
e = tmp(:,2)-tmp(:,1);
R2 = 1 - sum(e.^2)/sum(tmp(:,2).^2);
rmse = sqrt(mean(e.^2));
fprintf('Panel 1 R2 measure: %5.3f \n',R2);
fprintf('Panel 1 rmse measure: %5.2f \n',rmse);
figure_to_png(figdir, 'Scatter_1_k2');
close(fig);

% Out of sample
ismpl = smpl(calvec,[2020 3],Last_Obs_fs,12);
Y = data_fac_est(ismpl==1,:);
lin45 = linspace(-300,150,500)';
fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
%subplot(2,2,1);
X = Xfit_f_ols(ismpl==1,:);
scatter(X,Y,marker_sz,'blue','filled');
hold on;
%plot(lin45,lin45,'- k','LineWidth',1);
hold off;
xlim([-300 150]);
ylim([-300 150]);
title('(b) 2020:M3 - 2021:M9 (OLS)','FontSize',ax_fs);
xlabel('Fitted Value','FontSize',ax_fs);
ylabel('Actual','FontSize',ax_fs);
set(gca,'FontSize',ax_fs);
tmp = packr([X(:) Y(:)]);
e = tmp(:,2)-tmp(:,1);
R2 = 1 - sum(e.^2)/sum(tmp(:,2).^2);
rmse = sqrt(mean(e.^2));
fprintf('Panel 1 R2 measure: %5.3f \n',R2);
fprintf('Panel 1 rmse measure: %5.2f \n',rmse);
figure_to_png(figdir, 'Scatter_2a_k2');
close(fig);

ismpl = smpl(calvec,[2020 3],Last_Obs_fs,12);
Y = data_fac_est(ismpl==1,:);
lin45 = linspace(-300,150,500)';
fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
%subplot(2,2,2);
X = Xfit_f_mn(ismpl==1,:);
scatter(X,Y,marker_sz,'blue','filled');
hold on;
%plot(lin45,lin45,'- k','LineWidth',1);
hold off;
xlim([-300 150]);
ylim([-300 150]);
title('(c) 2020:M3 - 2021:M9 (WLS)','FontSize',ax_fs);
xlabel('Fitted Value','FontSize',ax_fs);
ylabel('Actual','FontSize',ax_fs);
set(gca,'FontSize',ax_fs);
tmp = packr([X(:) Y(:)]);
e = tmp(:,2)-tmp(:,1);
R2 = 1 - sum(e.^2)/sum(tmp(:,2).^2);
rmse = sqrt(mean(e.^2));
fprintf('Panel 1 R2 measure: %5.3f \n',R2);
fprintf('Panel 1 rmse measure: %5.2f \n',rmse);
figure_to_png(figdir, 'Scatter_2b_k2');
close(fig);

ismpl = smpl(calvec,[2020 3],Last_Obs_fs,12);
Y = data_fac_est(ismpl==1,:);
lin45 = linspace(-300,150,500)';
fig = figure('units','normalized','outerposition',[0 0 0.5 0.5]);
%subplot(2,2,2);
X = Xfit_f_g_mn(ismpl==1,:);
scatter(X,Y,marker_sz,'blue','filled');
hold on;
%plot(lin45,lin45,'- k','LineWidth',1);
hold off;
xlim([-300 150]);
ylim([-300 150]);
xlabel('Fitted Value','FontSize',ax_fs);
ylabel('Actual','FontSize',ax_fs);
set(gca,'FontSize',ax_fs);
tmp = packr([X(:) Y(:)]);
e = tmp(:,2)-tmp(:,1);
R2 = 1 - sum(e.^2)/sum(tmp(:,2).^2);
rmse = sqrt(mean(e.^2));
fprintf('Panel 1 R2 measure: %5.3f \n',R2);
fprintf('Panel 1 rmse measure: %5.2f \n',rmse);
figure_to_png(figdir, 'Scatter_3_k2');
close(fig);
