% Series Lists
% Plot Some Actual and Fitted Values over Covid Recession
sname_vec =[ ...
    {'UNJL_Layoff'};
    {'CES7072000001'};
    {'A063RC1R'};
    {'DHLCRG'};
    {'DFDHRG'};
    {'UNEMP15TO26Rate'};
    {'IPB52120S'};
    {'DTRSRG'} ... 
    ];   
titstr_vec = [ ...
    {'(a) CPS: Layoffs'};
    {'(b) CES: Accomodation and food services'};
    {'(c) PI: Government transfers to persons'};
    {'(d) PCE: Healthcare'};
    {'(e) PCE: Furnishing and durable household equipment'};
    {'(e) CPS: Unemployment rate (15 to 26 weeks)'};
    {'(g) IP: Information processing equipment'};
    {'(h) PCE: Transportation services'}...
    ];

leg_fs = 10;
ax_fs = 10;
fig = figure('units','normalized','outerposition',[0 0 0.5 0.75]);
ismpl = smpl(calvec,[2019 1],[2021 6],12);
x = calvec(ismpl==1);
for ii = 1:length(sname_vec)
  aa = char(sname_vec(ii));
  tmp = ismember(Sname,aa);
  [~,ig]=max(tmp);
subplot(4,2,ii);
 y = sgn_procycl(ig)*[data_fac_est(ismpl==1,ig) Xfit_f_mn(ismpl==1,ig)];
 %aa = char(Sdesc(ig));
 aa = char(titstr_vec(ii));
 plot(x,y(:,1),'- k','LineWidth',2);
 hold on;
  plot(x,y(:,2),'-- b','LineWidth',2);
 hold off;
 title(aa);
 if(ii == 1)
   legend('Data','Fitted Values (F)','Location','NorthWest','FontSize',leg_fs);
 end
 set(gca,'FontSize',ax_fs);
 xlabel('Date','FontSize',ax_fs);
 ylabel('Standard Deviations','FontSize',ax_fs);
 T = table(x,y);
 fname = [xlsxdir 'Figure_4_' num2str(ii) '_k2.xlsx'];
 writetable(T,fname);
end
 
figure_to_png(figdir, 'Actual_Fitted_f_k2');
close(fig);

leg_fs = 7;
fig = figure('units','normalized','outerposition',[0 0 0.5 0.75]);
ismpl = smpl(calvec,[2019 1],[2021 6],12);
x = calvec(ismpl==1);
for ii = 1:length(sname_vec)
  aa = char(sname_vec(ii));
  tmp = ismember(Sname,aa);
  [~,ig]=max(tmp);
subplot(4,2,ii);
 y = sgn_procycl(ig)*[data_fac_est(ismpl==1,ig) Xfit_f_mn(ismpl==1,ig) Xfit_f_g_mn(ismpl==1,ig)];
 %aa = char(Sdesc(ig));
 aa = char(titstr_vec(ii));
 plot(x,y(:,1),'- k','LineWidth',2);
 hold on;
  plot(x,y(:,2),'-- b','LineWidth',2);
  plot(x,y(:,3),': r','LineWidth',3);	
 hold off;
 title(aa);
 if(ii == 1)
   legend('Data','Fitted Values (F)','Fitted Valued (F and G)','Location','NorthWest','FontSize',leg_fs);
 end
 set(gca,'FontSize',ax_fs);
 xlabel('Date','FontSize',ax_fs);
 ylabel('Standard Deviations','FontSize',ax_fs);
end

figure_to_png(figdir, 'Actual_Fitted_f_g_k2');
close(fig);


sname_vec =[ ...
    {'PIR'};
    {'INDPRO'};
    {'PAYEMS'};
    {'UNEMPLOYRate'};
    {'DPCERG'};
    {'HOUST'};
    {'DGDSRG'};
    {'DSERRG'} ... 
    ];   
titstr_vec = [ ...
    {'(a) Personal income'}; 
    {'(b) Industrial production'};
    {'(c) Nonfarm employment'};
    {'(d) Unemployment rate'};
    {'(e) PCE Total'};
    {'(f) Housing Starts'};
    {'(g) PCE Goods'};
    {'(h) PCE Services'}...
    ];

fig = figure('units','normalized','outerposition',[0 0 0.5 0.75]);
ismpl = smpl(calvec,[2019 1],[2021 6],12);
x = calvec(ismpl==1);
for ii = 1:length(sname_vec)
  aa = char(sname_vec(ii));
  tmp = ismember(Sname,aa);
  [~,ig]=max(tmp);
subplot(4,2,ii);
 y = sgn_procycl(ig)*[data_fac_est(ismpl==1,ig) Xfit_f_mn(ismpl==1,ig) Xfit_f_g_mn(ismpl==1,ig)];
 aa = char(Sdesc(ig));
 plot(x,y(:,1),'- k','LineWidth',2);
 hold on;
  plot(x,y(:,2),'-- b','LineWidth',2);
  %plot(x,y(:,3),': r','LineWidth',3);	
 hold off;
 title(aa);
 if(ii == 1)
   legend('Data','Fitted Values (F)','Location','NorthWest','FontSize',leg_fs);
 end
 set(gca,'FontSize',ax_fs);
 xlabel('Date','FontSize',ax_fs);
 ylabel('Standard Deviations','FontSize',ax_fs);
end
 
figure_to_png(figdir, 'Actual_fitted_f_aggregates_k2');
close(fig);

fig = figure('units','normalized','outerposition',[0 0 0.5 0.75]);
ismpl = smpl(calvec,[2019 1],[2021 6],12);
x = calvec(ismpl==1);
for ii = 1:length(sname_vec)
  aa = char(sname_vec(ii));
  tmp = ismember(Sname,aa);
  [~,ig]=max(tmp);
subplot(4,2,ii);
 y = sgn_procycl(ig)*[data_fac_est(ismpl==1,ig) Xfit_f_mn(ismpl==1,ig) Xfit_f_g_mn(ismpl==1,ig)];
 aa = char(Sdesc(ig));
 plot(x,y(:,1),'- k','LineWidth',2);
 hold on;
  plot(x,y(:,2),'-- b','LineWidth',2);
  plot(x,y(:,3),': r','LineWidth',3);	
 hold off;
 title(aa);
 if(ii == 1)
   legend('Data','Fitted Values (F)','Fitted Valued (F and G)','Location','NorthWest','FontSize',leg_fs);
 end
 set(gca,'FontSize',ax_fs);
 xlabel('Date','FontSize',ax_fs);
 ylabel('Standard Deviations','FontSize',ax_fs);
end
 
figure_to_png(figdir, 'Actual_fitted_f_g_aggregates_k2');
close(fig);
