% Series Lists
% Plot Some Actual and Fitted Values over Covid Recession
for i_series = 1: n_series
 fig = figure('units','normalized','outerposition',[0 0 0.5 0.75]);
 ismpl = smpl(calvec,[2019 1],Last_Obs_fs,12);
 x = calvec(ismpl==1);
 y = sgn_procycl(i_series)*[data_fac_est(ismpl==1,i_series) Xfit_f_mn(ismpl==1,i_series)];
 aa = char(Sdesc(i_series));
 plot(x,y(:,1),'- k','LineWidth',2);
 hold on;
  plot(x,y(:,2),'-- b','LineWidth',2);
 hold off;
 title(aa);
 legend('Data','Fitted Values (F)','Location','NorthWest','FontSize',leg_fs);
 set(gca,'FontSize',ax_fs);
 xlabel('Date','FontSize',ax_fs);
 ylabel('Standard Deviations','FontSize',ax_fs);
 figure_to_png(figdir_all, ['Actual_Fitted_f_' num2str(i_series)]);
 close(fig);
end;

for i_series = 1: n_series
 fig = figure('units','normalized','outerposition',[0 0 0.5 0.75]);
 ismpl = smpl(calvec,[2019 1],Last_Obs_fs,12);
 x = calvec(ismpl==1);
 y = sgn_procycl(i_series)*[data_fac_est(ismpl==1,i_series) Xfit_f_mn(ismpl==1,i_series)  Xfit_f_g_mn(ismpl==1,i_series)];
 aa = char(Sdesc(i_series));
 plot(x,y(:,1),'- k','LineWidth',2);
 hold on;
  plot(x,y(:,2),'-- b','LineWidth',2);
  plot(x,y(:,3),': r','LineWidth',3);	
 hold off;
 title(aa);
 legend('Data','Fitted Values (F)','Fitted Valued (F and G)','Location','NorthWest','FontSize',leg_fs);
 set(gca,'FontSize',ax_fs);
 xlabel('Date','FontSize',ax_fs);
 ylabel('Standard Deviations','FontSize',ax_fs);
 figure_to_png(figdir_all, ['Actual_Fitted_f_g_' num2str(i_series)]);
 close(fig);
end;
