function [ acv ] = arma_acv(ar_coef,ma_coef,n_acv )
% % Compute autocovariances for ARMA model .. innovations have unit variance
% AR_coef and MA_coef should be entered as row vectors

nar = max(size(ar_coef));
nma = max(size(ma_coef));

% Assumes ar_coef and ar_ma are row vectors
% Make sure AR order is at least one nma+1
if nar < nma+1;
    ar_coef = [ar_coef zeros(1,nma-nar+1)];
    nar = nar + nma-nar+1;
end;
n_size = nar+nma;  % Size of state vector
M = zeros(n_size,n_size);
% first element is y(t)
M(1,:)=[ar_coef -ma_coef];  % note the minus sign on MA coefficients
% next nar-1 coefficients are lagged ys
M(2:nar,1:nar-1) = eye(nar-1);
% Next element is e(t)
M(nar+1,:) = zeros(1,n_size);
if nma > 1;
    M(nar+2:nar+nma,nar+1:nar+nma-1) = eye(nma-1);
end;
G = zeros(n_size,1);
G(1,1) = 1;
G(nar+1,1) = 1;
Q = G*G';

tmp = eye(n_size^2) - kron(M,M);
tmp = inv(tmp);
vec_Q = reshape(Q,n_size^2,1);
vec_sig = tmp*vec_Q;
sig = reshape(vec_sig,n_size,n_size);

acv = NaN(n_acv+1,1);
acv(1:nar) = sig(1,1:nar)';
for j = nar+1:n_acv+1;
    acv(j) = ar_coef*flipud(acv(j-nar:j-1));
end;

end

