function [xmean] = bp_trend(x,period_cutoff);
% Compute biweight trend by local averaging
 nobs = size(x,1);
 xmean = NaN*zeros(size(x,1),1);
 trend = (1:1:nobs)';
 inan = isnan(x);
 t_index = trend(inan==0);
 xp = x(inan==0);
 T = length(xp);
 ombar = 2*pi/period_cutoff;
 t1 = (1:1:T)';
 tmp0 = ombar/pi;
 tmp1 = (1./(pi*t1)).*sin(t1*ombar);
 bp_weight = [flipud(tmp1);tmp0;tmp1];
 for t = 1:T;
    wght=bp_weight(T+2-t:2*T+1-t);
    wght = wght/sum(wght);
    xmean(t_index(t))=wght'*xp;
 end;
end
