function [xmean,se_xmean] = bw_trend_se(x,bw_bw,ar_p);
% Compute biweight trend by local averaging
 if ar_p > 1; error('not implemented'); end;
 nobs = size(x,1);
 xmean = NaN*zeros(size(x,1),1);
 trend = (1:1:nobs)';
 inan = isnan(x);
 xp = x(inan==0);
 for t = 1:nobs;
   if inan(t) == 0;
    dt = (trend-t)/bw_bw;
    bw_weight = (15/16)*((1-dt.^2).^2);   % Bi-Weight 
    bw_weight = bw_weight.*(abs(dt) < 1);
    bw_weight = bw_weight(inan==0);
    bw_weight = bw_weight/sum(bw_weight);
    xmean(t)=bw_weight'*xp;
   end;
 end;
 
 % Compute Residuals
 e = x-xmean;
 ep = e(inan==0);
 % Estimate AR(p)
 if ar_p == 0;
  var_ep = mean(ep.^2);
  omega = var_ep*eye*(length(xp));
 else;
  rho = ep(1:end-1)\ep(2:end);
  res = ep(2:end)-rho*ep(1:end-1);
  var_res = sum(res.^2)/(length(res)-1);
  omega = var_res*AR1_cov(length(xp),rho);
 end;
 
 se_xmean = NaN*zeros(size(x,1),1);
 trend = (1:1:nobs)';
 inan = isnan(x);
 for t = 1:nobs;
   if inan(t) == 0;
    dt = (trend-t)/bw_bw;
    bw_weight = (15/16)*((1-dt.^2).^2);   % Bi-Weight 
    bw_weight = bw_weight.*(abs(dt) < 1);
    bw_weight = bw_weight(inan==0);
    bw_weight = bw_weight/sum(bw_weight);
    se_xmean(t)=sqrt(bw_weight'*omega*bw_weight);
   end;
 end;
  
end

