function [ ccor ] = crosscor(x,y,lag )
% This computes the correlation between x(t) and y(t-lag)
% Note that lag may be a vector, so ccor is the corresponding vector
% of cross correlations
ccor = NaN(length(lag),1);
for i = 1:length(lag);
    k = lag(i);
    if k >= 0;
        x1 = x(k+1:end);
        y1 = y(1:end-k);
    else;
        x1 = x(1:end+k);
        y1 = y(-k+1:end);
    end;
    z = packr([x1 y1]);
    tmp = corrcoef(z);
    ccor(i) = tmp(1,2);
end;
        
end

