function [y_mat] = generate_data_VAR_companion(T,nrep,Q,M,G,n_initial)
% Model is 
% y(t) = Q*x(t)
% x(t) = M*x(t-1) + G*u(t)
%
% var(u) = eye
%
% Generate nrep replications of vectors of y of length T
%
% initial value of x is zero
% n_initial periods are generated to approximate stationary distribution 
%
nx = size(M,1);
nu = size(G,2);
ny = size(Q,1);
x = zeros(nx,nrep);
for t = 1:n_initial;
    x = M*x + G*randn(nu,nrep);
end;
y_mat = NaN(T,ny,nrep);
for t = 1:T;
    x = M*x + G*randn(nu,nrep);
    y = Q*x;
    y_mat(t,:,:) = y;
end;
    
end

