function [y_mat] = generate_data_VAR_companion_circle_resid(T,nrep,Q,M,n_initial,var_resid)
% Model is 
% y(t) = Q*x(t)
% x(t) = M*x(t-1) + G*u(t)
%
% G = [eye(k) | 0]
% u is generated from var_resid by turning into circulant and multiplying
% by random +1 or -1 values.
%
% Generate nrep replications of vectors of y of length T
%
% initial value of x is zero
% n_initial periods are generated to approximate stationary distribution 
%
tmp = packr(var_resid);
uc = form_circ(tmp,2*(n_initial+T));
nu = size(var_resid,2);
nx = size(M,1);
ny = size(Q,1);
y_mat = NaN(T,ny,nrep);
for irep = 1:nrep;
 x = zeros(nx,1);
 % Randomly choose starting point of uc
 tt = ceil((n_initial+T)*rand(1,1));
 ui = uc(tt+1:tt+n_initial+T,:);
 for t = 1:n_initial;
    u = bs_11(ui(t,:)');
    x = M*x; 
    x(1:nu) = x(1:nu) + u;
 end;

 for t = 1:T;
    u = bs_11(ui(t+n_initial,:)');
    x = M*x; 
    x(1:nu) = x(1:nu) + u;
    y = Q*x;
    y_mat(t,:,irep) = y;
 end;
 
end;
    
end

