function [y_mat] = generate_data_univariate_ar_circle_resid(T,nrep,ar_coef,n_initial,resid)
% 

% Initial values set to zero
y_mat = NaN(T,nrep);

% Parameters
nar = max(size(ar_coef));
tmp = packr(resid);
if size(tmp) < 10;
    'fewer than 10 elements in residuals';
else;
    
 uc = form_circ(tmp,2*(n_initial+T));
 for irep = 1:nrep;
    ym = zeros(T+n_initial,1);
    % Randomly choose starting point of uc
    tt = ceil((n_initial+T)*rand(1,1));
    ui = uc(tt+1:tt+n_initial+T);
    for t = nar+1:T+n_initial;
       u = bs_11(ui(t));
       ym(t) = u;
       for iar = 1:nar;
           ym(t) = ym(t)+ar_coef(iar)*ym(t-iar);
       end;
    end;
    y_mat(:,irep) = ym(n_initial+1:end);
 end;
end;


end

