function [vardata] = getvar(varname,varnamevec,vardatamat)
% Get data on a variable from a data matrix
% input:
%       varname is a string with the variable of interest
%       varnamevec is a string vector containing all variable names:
%       n_series x 1
%       vardatamat is n x nseries data matrix. 

  j = colnumber(varname,varnamevec);
  if j > 0;
      vardata = vardatamat(:,j);
  else
      fprintf(['Variable: ' varname ' not found in dataset \n']);
      vardata = NaN;
  end;

end

