function [beta,vbeta,se_beta] = hom_tsls(y,x,w);
%{
     Modified by MWW, 3-8-14

     Procedure for estimating the regression y = xbeta+ u using 2SLS
     The procedure produces the TSLS estimate of b
     and a "homoskedastic only" variance
Input:
     y = tx1
     x = txk (regressors)
     w = tx1 (instruments)
     

Output:
     Beta = OLS estimate of beta (kx1)
    VBeta = Homoskedastic-only estimate of covariance matrix of beta (kxk)
            (Note this is computed used PINV, if X'X is singular

%}
xhat = w*(inv(w'*w)*(w'*x));
xx=xhat'*xhat;
xxi = inv(xx);
beta=xxi*(xhat'*y);
u=y-x*beta;
varu = sum(u.^2)/(size(xhat,1)-size(xhat,2));
vbeta = varu*xxi;
se_beta = sqrt(diag(vbeta));


end