function [y iy] =packr_a(x)

 % PACKR
 % PACKR(x) deletes all the rows of x that contain a MATLAB missing element (NaN)
 % It also returns an index vector of the rows that are not deleted
 t=isnan(x);
 c=sum(t,2)==0;
 T = (1:size(x,1))';
 y=x(c==1,:);
 iy=T(c==1,:);

end