function [pval] = pval_qlr(x,n,ccut)
%  Version of pval_qlr.prc, mww, 1/27/97, ported to Matlab 3/15/2015
%    Calculate pvalue for QLR tests.
%    x = value of test statistic
%    n = number of degrees of freedon
%    ccut = trimming constant
% 
%    Pvalue is computed using the approximation in
%    Hansen, 1995, JBES, "Approximate Asymptotic P Values ... "
%    pages 60-67.

% -- Note, this is now only implemented for ccut = .15 -- @
if ccut ~= .15;
   pval=9999;
else;


parmvec = ...
[[1    -0.99 1.02  3.0]; ...
[2    -1.65 1.06  4.7]; ...
[3    -2.05 1.13  6.8]; ...
[4    -2.52 1.11  8.0]; ...
[5    -3.46 1.07  8.3]; ...
[6    -4.05 1.08  9.5]; ...
[7    -4.42 1.10 11.0]; ...
[8    -5.36 1.08 11.3]; ...
[9    -5.43 1.10 13.1]; ...
[10   -6.47 1.06 12.8]; ...
[11   -6.79 1.04 13.5]; ...
[12   -7.80 1.02 13.6]; ...
[13   -7.93 1.07 15.9]; ...
[14   -8.54 1.05 16.1]; ...
[15   -9.05 1.05 17.2]; ...
[16   -9.13 1.09 19.3]; ...
[17  -10.45 1.05 18.3]; ...
[18  -10.63 1.05 19.5]; ...
[19  -12.14 0.90 14.9]; ...
[20  -12.14 0.97 18.3]; ...
[25  -14.16 1.05 25.0]; ...
[30  -17.06 1.03 27.8]; ...
[35  -20.09 0.98 28.4]; ...
[40  -21.65 1.05 36.7]];

  % Find Appropriate Row of Parmvec
  p = parmvec(parmvec(:,1)==n,2:end);
  x1 = p(1,1) + p(1,2)*x;
  if x1 >= 0;
     pval=1-chi2cdf(x1,p(1,3));
  else;
     pval=1;
  end;

end;

end

