function [ss] = spmod(h,f,g,w)
% Procedure for Calculating Spectral Density Matrix for a VAR model writen
% in companison form:

%      x(t)=h*s(t)
%      s(t)=f*s(t-1) + g*e(t)
% 
%      where var(e(t))=I
% 
%    Output:  ss = spectrum of x at frequency w.
%    Note: Spectrum is not divided by 2*pi
%    Spectrum is computed at frequency w
%
 im = sqrt(-1);
 z=exp(-w*im);
 sm=eye(size(f,1));
 sm=sm-z*f;
 smi=inv(sm);
 ss=h*smi*g*g'*smi'*h';
 
end
