% Estimate CSI weights

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rng(63761);

p1 = path;
path(p1,'../m_utilities');

 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  pc_comp_data_calendar_m_and_q_real;
  % Data Series Used
  dp_agg = dp_agg_q;
  dp_agg_xfe = dp_agg_xfe_q;
  dp_agg_xe = dp_agg_xe_q;
  dp_aggs = [dp_agg dp_agg_xfe dp_agg_xe];
  namevec_aggs = {'dp_agg';'dp_agg_xfe';'dp_agg_xe'};
  dp_disagg = dp_disagg_q;
  calvec_p = calvec_qp;
  calvec_r = calvec_qr;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  dp_disagg_zero = [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]';   % Coefficients set to zero
  'Coefficients set to zero:'
  labelvec_disagg(dp_disagg_zero==1)
  dp_non_zero = 1 - dp_disagg_zero;
  n_p = size(dp_disagg,2);
  dp_disagg_yoy = dif(ma(dp_disagg,4),4);
 
  % Load CAI
  str = [matdir 'cai'];load(str);
  
  % Iteration Parameters
  nit = 1500;
  options = optimset('Display','off');
  
first_date = [1984 1];
last_date = [2019 1];
ismpl_p = smpl(calvec_p,first_date,last_date,4);
ismpl_r = smpl(calvec_r,first_date,last_date,4);
calvec_est = calvec_p(ismpl_p==1);

% Step 1:  Regress ybp_pc onto inflation measures .. compute R2
y = cai(ismpl_r==1);
x = dp_disagg_yoy(ismpl_p==1,dp_non_zero'==1);
x = x - mean(x);
fdata.z = x;
fdata.y = y;
theta_max = zeros(size(x,2)-1,1);
fmin = 0;
fmin_save = fmin;
theta_save = theta_max;   
tic;
for i = 1:nit;
  if floor(i/2) == ceil(i/2);
      theta = theta + .02*randn(size(x,2)-1,1);
  else;
      theta = 0.5*randn(size(x,2)-1,1);
  end;
  theta = fminsearch(@(x) myfun4(x,fdata),theta,options); 
  tmp = myfun4(theta,fdata);
  if tmp < fmin;
    theta_max = theta;
    fmin = tmp;
    theta_save = [theta_max theta_save];
    fmin_save = [fmin;fmin_save];
  end;
end;
b_logit = logit_wght(theta_save(:,1));
w_logit = zeros(n_p,1);
w_logit(dp_non_zero==1) = b_logit;
xhat = x*w_logit;
szz = sum(xhat.^2);
ydm = y-mean(y);
syy = sum(ydm.^2);
szy = sum(xhat.*ydm);

% Save CSI weights
str_tmp = [matdir 'w_logit_benchmark'];
save(str_tmp,'w_logit');

path(p1);


  