% Scatter plots with inflation .. Figu


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');

bw_bw = 60;   % Bi-weight bandwidth 

 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  pc_comp_data_calendar_m_and_q_prices;
  calvec_r = calvec_qr;
  calvec_p = calvec_qp;
  
  % GDO
  log_gdo = 0.5*log(gdp)+0.5*log(gdi);
  if isnan(gdi(end)) == 1;  % Last observation is missing, use GDP growth for last entry;
      log_gdo(end) = log_gdo(end-1) + log(gdp(end)) - log(gdp(end-1));
  end;
 
  dp_agg_xfe_yoy = dif(ma(dp_agg_xfe_q,4),4);
  dp_agg_yoy = dif(ma(dp_agg_q,4),4);
  
  urate = urate *100;
  urate_cbo_gap = urate - u_nr;
  urate_cbo_gap_ma4 = ma(urate_cbo_gap,4);
 
  ismpl_p_1 = smpl(calvec_p,[1961 1],[1983 4],4);
  ismpl_p_2 = smpl(calvec_p,[1984 1],[1999 4],4);
  ismpl_p_3 = smpl(calvec_p,[2000 1],[2019 1],4);
  ismpl_r_1 = smpl(calvec_r,[1961 1],[1983 4],4);
  ismpl_r_2 = smpl(calvec_r,[1984 1],[1999 4],4);
  ismpl_r_3 = smpl(calvec_r,[2000 1],[2019 1],4);
  ismpl_r_0 = smpl(calvec_r,[1961 1],[2019 4],4);
 
  xx = urate_cbo_gap_ma4;
  mxx = max(packr(xx(ismpl_r_0==1)));
  nn = 100;
  wmat = [ones(nn,1) linspace(-2.5,mxx,nn)'];
  xmat = linspace(-2.5,mxx,nn)';
  
  yy= dp_agg_yoy;
  
  tit_fs = 45;
  ax_fs = 40;
  txt_fs = 40;
  mk_sz = 25;
  
  figure;
  x = xx(ismpl_r_1==1);
  y = yy(ismpl_p_1==1);
  plot(x,y,'bo','MarkerFaceColor','b','MarkerSize',mk_sz);
  ylim([-5 5]);
  xlim([-3 6]);
  hold on;
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(4.3,-2.55,txt,'Color','blue','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- b','LineWidth',4);
    
    x = xx(ismpl_r_2==1);
    y = yy(ismpl_p_2==1);
    plot(x,y,'rd','MarkerFaceColor','r','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(4.4,-1.2,txt,'Color','red','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- r','LineWidth',4);
    
    x = xx(ismpl_r_3==1);
    y = yy(ismpl_p_3==1);
    plot(x,y,'ks','MarkerFaceColor','k','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(4.8,0.10,txt,'Color','black','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- k','LineWidth',4);
  hold off;
  ax = gca;
  ax.FontSize = ax_fs;
  xlabel('Unemployment gap');
  ylabel('Year-over-year change in inflation');
  title('Headline PCE','FontSize',tit_fs);
  ss1 = ['Figure_1a_pce_headline'];
  figure_to_png(figdir,ss1);
  close(gcf);
  
  yy= dp_agg_xfe_yoy;
  figure;
  x = xx(ismpl_r_1==1);
  y = yy(ismpl_p_1==1);
  plot(x,y,'bo','MarkerFaceColor','b','MarkerSize',15);
  ylim([-5 5]);
  xlim([-3 6]);
  hold on;
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(4.4,-1.8,txt,'Color','blue','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- b','LineWidth',4);
    
    x = xx(ismpl_r_2==1);
    y = yy(ismpl_p_2==1);
    plot(x,y,'rd','MarkerFaceColor','r','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(4.5,-1.1,txt,'Color','red','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- r','LineWidth',4);
    
    x = xx(ismpl_r_3==1);
    y = yy(ismpl_p_3==1);
    plot(x,y,'ks','MarkerFaceColor','k','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(4.8,0.08,txt,'Color','black','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- k','LineWidth',4);
  hold off;
  ax = gca;
  ax.FontSize = ax_fs;
  xlabel('Unemployment gap');
  ylabel('Year-over-year change in inflation');
  title('Core PCE','FontSize',tit_fs);
  ss1 = ['Figure_1b_pce_cor'];
  figure_to_png(figdir,ss1);
  close(gcf);
  
  path(p1);

 
 

  