% Figures 10 and 11

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rng(63761);

p1 = path;
path(p1,'../m_utilities');

% -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
 
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  pc_comp_data_calendar_m_and_q_real;
  % Data Series Used
  dp_disagg = dp_disagg_q;
  calvec_p = calvec_qp;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  calvec_r = calvec_qr;
  calds_r = calds_qr;
  dnobs_r = dnobs_qr;
  
  dp_disagg_yoy = dif(ma(dp_disagg,4),4);
  
  % Read in weights
  str_tmp = [matdir 'w_logit_benchmark']; load(str_tmp);
  
  csi_level = dp_disagg*w_logit;
  csi_yoy = dp_disagg_yoy*w_logit;
  
  % Load CAI
  str = [matdir 'cai'];load(str);
  
  first_date = [1961 1];
  last_date = [2019 1];
  ismpl_p = smpl(calvec_p,first_date,last_date,4);
  ismpl_r = smpl(calvec_r,first_date,last_date,4);
  
  % Figure 10
  ax_fs = 30;
  cai_tmp = cai(ismpl_r==1);
  csi_tmp = csi_yoy(ismpl_p==1);
  cai_tmp = standardize(cai_tmp);
  cai_tmp = cai_tmp*std(csi_tmp);
  plot(calvec_r(ismpl_r==1),cai_tmp,'-- b','LineWidth',3);
  hold on;
     plot(calvec_p(ismpl_p==1),csi_tmp,'- k','LineWidth',3);
  hold off;
  h=legend('Cyclical activity index','CSI (yoy)','Location','northeast');
  set(h,'FontSize',ax_fs);
  xlim([1960 2020]);
  ax = gca;
  ax.FontSize = ax_fs;
  h=vline(1984,'- k','');
  figure_to_png(figdir,'Figure_10');
  close(gcf);
  
  
  % Figure 11
  dp_pceall = dp_agg_q;
  dp_pcexfe = dp_agg_xfe_q;
  csi_level_ma4 = ma(csi_level,4);
  dp_pceall_ma4 = ma(dp_pceall,4);
  dp_pcexfe_ma4 = ma(dp_pcexfe,4);
  first_date = [1960 1];
  last_date = [2019 1];
  ismpl_p = smpl(calvec_p,first_date,last_date,4);
    
  ax_fs = 30;
  plot(calvec_p(ismpl_p==1),csi_level_ma4(ismpl_p==1),'- k','LineWidth',3);
  hold on;
     plot(calvec_p(ismpl_p==1),dp_pceall_ma4(ismpl_p==1),'-- b','LineWidth',3);
     plot(calvec_p(ismpl_p==1),dp_pcexfe_ma4(ismpl_p==1),': r','LineWidth',3);
  hold off;
  h=legend('CSI','PCE all items','PCE excluding food and energy','Location','northeast');
  set(h,'FontSize',ax_fs);
  legend('AutoUpdate','off');
  xlim([1960 2020]);
  ylim([-2 12]);
  ax = gca;
  ax.FontSize = ax_fs;
  x_lim = ax.XLim;
  y_lim = ax.YLim;
  recession_bars(x_lim,y_lim);
  figure_to_png(figdir,'Figure_11');
  close(gcf);
  
  path(p1);

  

 