% Scatter plots with inflation


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');

bw_bw = 60;   % Bi-weight bandwidth 

 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  pc_comp_data_calendar_m_and_q_prices;
  calvec_r = calvec_qr;
  calvec_p = calvec_qp;
  dp_disagg = dp_disagg_q;
  
  % Load CSI weights
  str_tmp = [matdir 'w_logit_benchmark']; load(str_tmp);
  csi_level = dp_disagg*w_logit;
  csi_yoy = dif(ma(csi_level,4),4);
  
  % BP
  dp_disagg_bp = NaN(size(dp_disagg));
  for i = 1: size(dp_disagg,2);
      [dp_disagg_bp(:,i) tmp] =  bpassar(dp_disagg(:,i),updc,lpdc,n,nar,tcode,seflag);
  end;
  csi_bp = dp_disagg_bp*w_logit;
  
  % Load CAI
  str = [matdir 'cai'];load(str);
  % standardize
  cai = standardize(cai);
  
  % Scale CAI so it has stdev as urate-gap
  urate = urate *100;
  urate_cbo_gap = urate - u_nr;
  ismpl = smpl(calvec_r,[1961 1],[2019 4],4);
  scl_ugap = std(urate_cbo_gap(ismpl==1));
  m_ugap = mean(urate_cbo_gap(ismpl==1))
  cai_scl = -cai*scl_ugap+m_ugap;       
   
  ismpl_p_1 = smpl(calvec_p,[1961 1],[1983 4],4);
  ismpl_p_2 = smpl(calvec_p,[1984 1],[1999 4],4);
  ismpl_p_3 = smpl(calvec_p,[2000 1],[2019 1],4);
  ismpl_r_1 = smpl(calvec_r,[1961 1],[1983 4],4);
  ismpl_r_2 = smpl(calvec_r,[1984 1],[1999 4],4);
  ismpl_r_3 = smpl(calvec_r,[2000 1],[2019 1],4);
  ismpl_r_0 = smpl(calvec_r,[1961 1],[2019 1],4);
  
  xx = cai_scl;
  mxx = max(packr(xx(ismpl_r_0==1)));
  nn = 100;
  wmat = [ones(nn,1) linspace(-3,mxx,nn)'];
  xmat = linspace(-3,mxx,nn)';
  yy= csi_yoy;
  
  
  tit_fs = 45;
  ax_fs = 40;
  txt_fs = 40;
  mk_sz = 25;
  
  figure;
  x = xx(ismpl_r_1==1);
  y = yy(ismpl_p_1==1);
  plot(x,y,'bo','MarkerFaceColor','b','MarkerSize',15);
  ylim([-5 5]);
  xlim([-3 3]);
  hold on;
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(-2.9,1.65,txt,'Color','blue','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- b','LineWidth',4);
    
    x = xx(ismpl_r_2==1);
    y = yy(ismpl_p_2==1);
    plot(x,y,'rd','MarkerFaceColor','r','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(-2.8,0.5,txt,'Color','red','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- r','LineWidth',4);
    
    x = xx(ismpl_r_3==1);
    y = yy(ismpl_p_3==1);
    plot(x,y,'ks','MarkerFaceColor','k','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(-2.95,1.25,txt,'Color','black','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- k','LineWidth',4);
  hold off;
  ax = gca;
  ax.FontSize = 25;
  xlabel('CAI ({\times} -1 and scaled)');
  ylabel('CSI (yoy)');
  title('YoY CSI inflation versus CAS ({\times} -1)','FontSize',tit_fs);
  ss1 = ['Figure_12a_yoy_csi_cai'];
  figure_to_png(figdir,ss1);
  close(gcf);
  
  
  yy= csi_bp;
  figure;
  x = xx(ismpl_r_1==1);
  y = yy(ismpl_p_1==1);
  plot(x,y,'bo','MarkerFaceColor','b','MarkerSize',15);
  ylim([-5 5]);
  xlim([-3 3]);
  hold on;
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(-2.93,0.7,txt,'Color','blue','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- b','LineWidth',4);
    
    x = xx(ismpl_r_2==1);
    y = yy(ismpl_p_2==1);
    plot(x,y,'rd','MarkerFaceColor','r','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(-2.6,0.54,txt,'Color','red','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- r','LineWidth',4);
    
    x = xx(ismpl_r_3==1);
    y = yy(ismpl_p_3==1);
    plot(x,y,'ks','MarkerFaceColor','k','MarkerSize',mk_sz);
    w = [ones(size(x,1),1) x];
    tmp = packr([y w]);
    y = tmp(:,1);
    w = tmp(:,2:end);
    b = w\y;
    txt = num2str(b(2),'%5.2f');
    text(-2.7,1.3,txt,'Color','black','FontSize',txt_fs);
    yfit = wmat*b;
    plot(xmat,yfit,'- k','LineWidth',4);
  hold off;
  ax = gca;
  ax.FontSize = 25;
  xlabel('CAI ({\times} -1 and scaled)');
  ylabel('CSI (bandpass)');
  title('Bandpass CSI inflation versus CAS ({\times} -1)','FontSize',tit_fs);
  ss1 = ['Figure_12b_bp_csi_cai'];
  figure_to_png(figdir,ss1);
  close(gcf);
  
  path(p1);