% Estimate CSI .. US data

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rng(63761);

p1 = path;
path(p1,'../m_utilities');

% -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
% -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  pc_comp_data_calendar_m_and_q_real;
  % Data Series Used
  dp_disagg = dp_disagg_q;
  calvec_p = calvec_qp;
  calvec_r = calvec_qr;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  dp_disagg_zero = [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]';   % Coefficients set to zero
  'Coefficients set to zero:'
  labelvec_disagg(dp_disagg_zero==1)
  dp_non_zero = 1 - dp_disagg_zero;
  n_p = size(dp_disagg,2);
  dp_disagg_ma4 = ma(dp_disagg,4);
  dp_disagg_dif = dif(dp_disagg_ma4,4);
  
  % Load CAI
  str = [matdir 'cai'];load(str);
  % Read in benchmark weights
  str_tmp = [matdir 'w_logit_benchmark']; load(str_tmp);
  w_logit_benchmark = w_logit;
  
  
  % Iteration Parameters
  options = optimset('Display','off');
  

% Compute Rolling estimates
nroll = 60;              % Rolling weights over nroll periods
first_date = [1969 2];   % This is 1984:1 minus 60 quarters
last_date = [2019 1];
ismpl_p = smpl(calvec_p,first_date,last_date,4);
ismpl_r = smpl(calvec_r,first_date,last_date,4);
calvec = calvec_r(ismpl_r==1);
n_t = size(calvec,1);
dp_disagg_dif_tmp = dp_disagg_dif(ismpl_p==1,dp_non_zero'==1);
cai_tmp = cai(ismpl_r==1);

% Compute rolling results
nfirst = 1;
nit_1 = 500;
nit_2 = 100;

w_logit_rolling = NaN(n_t,17);

for i_t = nroll:n_t;
  calvec(i_t)
  % OLS Results
    y = cai_tmp(i_t-nroll+1:i_t);
    x = dp_disagg_dif_tmp(i_t-nroll+1:i_t,:);
    x = x - mean(x);
    fdata.z = x;
    fdata.y = y;  
    if nfirst == 1
       theta = 0.5*randn(size(x,2)-1,1);
       fmin = 0;
       theta_max = zeros(size(x,2)-1,1);
       nit = nit_1;
    else
       theta = theta_save(:,1);
       fmin = myfun4(theta,fdata);
       theta_max = theta;
       nit = nit_2;
    end
    nfirst = 0;
    fmin_save = fmin;
    theta_save = theta_max; 
    for i = 1:nit;
        if i > 1
            theta = 0.5*randn(size(x,2)-1,1);
        end
        theta = fminsearch(@(x) myfun4(x,fdata),theta,options); 
        tmp = myfun4(theta,fdata);
        if tmp < fmin
          theta_max = theta;
          fmin = tmp;
          theta_save = [theta_max theta_save];
          fmin_save = [fmin;fmin_save];
        end
    end;
    b_logit = logit_wght(theta_save(:,1));
    w_logit = zeros(n_p,1);
    w_logit(dp_non_zero==1) = b_logit;
    w_logit_rolling(i_t,:) = w_logit';
end;
tmp = NaN(size(dp_disagg_dif));
tmp(ismpl_p==1,:) = w_logit_rolling;
w_logit_rolling = tmp;

% Save w_logit_rolling
str_tmp = [matdir 'w_logit_rolling'];
save(str_tmp,'w_logit_rolling');

% Construct CSI with Different weights
str_tmp = [matdir 'w_logit_rolling'];
load(str_tmp);

csi_benchmark = dp_disagg_dif*w_logit_benchmark;
csi_rolling = sum(dp_disagg_dif.*w_logit_rolling,2);

% Figure 13
first_date = [1984 1];
last_date = [2019 1];
ismpl_p = smpl(calvec_p,first_date,last_date,4);
ismpl_r = smpl(calvec_r,first_date,last_date,4);
calvec = calvec_r(ismpl_r==1);

ax_fs = 30;
plot(calvec,csi_benchmark(ismpl_p==1),'- k','LineWidth',3);
hold on;
 plot(calvec,csi_rolling(ismpl_p==1),'-- b','LineWidth',3);
hold off;
h=legend('CSI (benchmark weights)','CSI (rolling weights)','Location','south');
set(h,'FontSize',ax_fs);
xlim([1980 2020]);
ax = gca;
ax.FontSize = ax_fs;
figure_to_png(figdir,'Figure_13');
close(gcf);

path(p1);