% Plot Gaps, etc .. Figure 2


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);
 
p1 = path;
p2 = path(p1,'../m_utilities');
path(p2,'../m_utilities/simonhenin-columnlegend-8883602');

 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  bw_bw = 60;   % Bandwidth for biweight mean
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  calvec_r = calvec_qr;
  
  % GDO
  log_gdo = 0.5*log(gdp)+0.5*log(gdi);
  if isnan(gdi(end)) == 1;  % Last observation is missing, use GDP growth for last entry;
      log_gdo(end) = log_gdo(end-1) + log(gdp(end)) - log(gdp(end-1));
  end;
  
  urate = urate *100;
  urate_cbo_gap = urate - u_nr;
  log_gdp_cbo_gap = log_gdo - log(gdp_pot);
  
  urate_gap = xgap_bw(urate,bw_bw);
  urate_st_gap = xgap_bw(urate_st,bw_bw);
  emp_pop_gap = xgap_bw(emp_pop,bw_bw);
  emp2554_pop_gap = xgap_bw(emp2554_pop,bw_bw);
  capu_gap = xgap_bw(capu,bw_bw);
  
  % Construct Gap ..
  ismpl = smpl(calvec_r,[1984 1],[2019 1],4);
  x_dat = [urate_cbo_gap -log_gdp_cbo_gap urate_gap urate_st_gap -emp_pop_gap -emp2554_pop_gap];
  x_dat_std = zscore(x_dat(ismpl==1,:));
  gap_index = NaN(size(urate));
  % Compute first PC
  [coeff,score,latent,tsquared,explained,mu] = pca(x_dat_std);
  gap_index(ismpl==1) = score(:,1);
  
  slack_mat = [gap_index urate_cbo_gap -log_gdp_cbo_gap urate_gap urate_st_gap -emp_pop_gap -emp2554_pop_gap -capu_gap];
  
  str_title = { ...
  	  'First principal component' ...
      'Unemployment gap (CBO)' ...
      'GDP gap (CBO)' ...
      'Unemployment gap (2-sided filtered)' ...
      'Short-term unemployment gap (2-sided filtered)' ...
      'Employment-population ratio (2-sided filtered)' ...
      'Employment-population ratio ages 25-54 (2-sided filtered)' ...
      'Capacity utilization rate (2-sided filtered)' ...
   };
   
  % Transform Slack Measures to have same and SD as Urate_cbo over
  % 1984-2019 period
  ismpl = smpl(calvec_r,[1984 1],[2019 1],4);
  tmp = slack_mat(ismpl==1,:);
  mean_std = mean(tmp(:,2));
  std_std = std(tmp(:,2));
  for i = 1:size(slack_mat,2);
      tmp = slack_mat(ismpl==1,i);
      m = mean(packr(tmp));
      s = std(packr(tmp));
      slack_mat(:,i) = (slack_mat(:,i)-m)/s;
      slack_mat(:,i) = slack_mat(:,i)*std_std+mean_std;
  end;
  
  figure;
  ismpl = smpl(calvec_r,[1984 1],[2019 1],4);
  ax_fs = 30;
  plot(calvec_r(ismpl==1),slack_mat(ismpl==1,1),'- k','LineWidth',4);
  hold on;
  plot(calvec_r(ismpl==1),slack_mat(ismpl==1,2:end),'--','LineWidth',2);
  hold off;
  xlim([1980 2020]);
  ylim([-6 7]);
  ax = gca;
  ax.FontSize = ax_fs;
  set(gcf, 'Position', get(0, 'Screensize'));  % Full Screen
  columnlegend(2,str_title,'Location','SouthWest','boxon');
  figure_to_png(figdir,'Figure_2_Slack_gaps');
  close(gcf);
  
  path(p1);
  
  

  