clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');


 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';

% Plot some gains
np = 500;
pi_vec = linspace(0,pi,np)';

bp_gain = zeros(np,1);
bp_l = 2*pi/32;
bp_u = 2*pi/6;
bp_gain = (pi_vec >= bp_l).*(pi_vec <= bp_u);

lpdc = 32;
updc = 6;
n = 40;
avec = bpweight(updc,lpdc,n);
bp_gain_truncated = NaN(np,1);
for i = 1:np;
    [bp_gain_truncated(i) ~] = gain_phase(avec,pi_vec(i));
end;

% Other Gain
dif4_gain = zeros(np,1);
dif4_phase = zeros(np,1);
dif4_poly = [1 0 0 0 -1]';
for i = 1:np;
    [dif4_gain(i) dif4_phase(i)] = gain_phase(dif4_poly,pi_vec(i));
end;

ma4_gain = zeros(np,1);
ma4_phase = zeros(np,1);
ma4_poly = [1 1 1 1]'/4;
for i = 1:np;
    [ma4_gain(i) ma4_phase(i)] = gain_phase(ma4_poly,pi_vec(i));
end;

difma4_gain = dif4_gain.*ma4_gain;

% HP Filter
n = 201;
alpha = 1600;
HP_WGHT = hp_weights(n,alpha );
hpma = HP_WGHT(101,:)';
hp_gain = zeros(np,1);
for i = 1:np;
    [hp_gain(i) ~] = gain_phase(hpma,pi_vec(i));
end;
hp_gain = ones(np,1)-hp_gain;

% Biweight   
bw_bw = 60;   % Bi-Weight Parameter for local demeaning
trend = (0:1:100)';
dt = trend/bw_bw;
bw_weight = (15/16)*((1-dt.^2).^2);   % Bi-Weight 
bw_weight = bw_weight.*(abs(dt) < 1);
tmp = flipud(bw_weight(2:end));
bw_weight = [tmp ; bw_weight];
bw_weight = bw_weight/sum(bw_weight);
tmp = flipud(trend(2:end));
trend = [-tmp ; trend];

% Compute Gain
bw_gain = zeros(np,1);
for i = 1:np;
    [bw_gain(i) ~] = gain_phase(bw_weight,pi_vec(i));
end;
bw_gain = 1-bw_gain;

figure;
plot(pi_vec,bp_gain,'- k','LineWidth',4)
hold on;
  plot(pi_vec,bp_gain_truncated,'- k','LineWidth',1)
  plot(pi_vec,difma4_gain,': b','LineWidth',4)
  plot(pi_vec,hp_gain,'-. r','LineWidth',4)
  plot(pi_vec,bw_gain,'- b','LineWidth',1)
hold off;
ylim([0 2.5]);
xlim([0 pi]);
ax = gca;

ax.XTickLabelMode = 'manual';
ax.XTickMode = 'manual';
ax.XTickLabel = {'96', '32','6','4','3','2'};
ax.XTick =      [2*pi/96, 2*pi/32, 2*pi/6, 2*pi/4,2*pi/3,2*pi/2];
ax.XLim = [0 pi+0.1];
ax.FontSize = 35;
xlabel('Period (quarters)');
ylabel('Power');
legend('bandpass (ideal)','bandpass (truncated)','year-over-year','HP','biweight','location','north');
figure_to_png(figdir,'Figure_3_Plot_Gain');
close(gcf);

fig=figure;
plot(pi_vec,bp_gain,'- k','LineWidth',4)
hold on;
  plot(pi_vec,bp_gain_truncated,'- k','LineWidth',1)
  plot(pi_vec,difma4_gain,': b','LineWidth',4)
  plot(pi_vec,hp_gain,'-. r','LineWidth',4)
  plot(pi_vec,bw_gain,'- b','LineWidth',1)
hold off;
ylim([0 2.5]);
xlim([0 pi]);
% ax = gca;
% ax.XTickLabelMode = 'manual';
% ax.XTickMode = 'manual';
% ax.XTickLabel = {'96', '32','6','4','3','2'};
% ax.XTick =      [2*pi/96, 2*pi/32, 2*pi/6, 2*pi/4,2*pi/3,2*pi/2];
% ax.XLim = [0 pi+0.1];
% ax.FontSize = 35;
xlabel('Period (quarters)');
ylabel('Power');
legend('bandpass (ideal)','bandpass (truncated)','year-over-year','HP','biweight','location','north');
orient landscape;
print(fig, [figdir, 'Figure_3_Plot_Gain'], '-dpdf','-bestfit');
close(gcf);

path(p1);


%-- BPWEIGHT --%
    function avec = bpweight(updc,lpdc,n);
        %BPWEIGHT  Computes bandpass filter weights using upper and lower
        %          cutoff periods.
        % Input:
        %   updc = Period corresponding to upper cutoff frequency
        %   lpdc = Period corresponding to lower cutoff frequency
        %      n = number of terms in moving average filter
        %Note: updc = 2 makes this a high pass filter (since period=2
        %      implies omega=pi)
               
        % Implied frequencies %
        omubar = 2*pi / updc;
        omlbar = 2*pi / lpdc; 
        
        %To construct a low pass filter, with cutoff at frequency of
        %"ombar", we note that the transfer function of the approximating
        %filter is given by:
        %
        %  alpha(om) = a0 + a1 cos(om) + ...+ aK cos(K om)
        %
        %and the ak's are given by:
        %
        % a0 = ombar/pi
        %
        % ak = sin(k ombar)/ (k pi)
        %
        %where ombar is the cutoff frequency
        
        %We employ the fact that a bandpass filter is the difference
        %between two low pass filters, 
        %             bp(L) = bu(L) - bl(L)
        %with bu(L) being the filter witht he high cutoff point and bl(L)
        %being that with the low cutoff point.
        
        %Define the vector of k's to be studied %
        
        %Set the grid for om %
        step =0.01; np=(2/step) + 1;
        om = (-1:step:1)'; %evenly spaced grip from -1 to 1.
        
        om = pi*om;
        omp= om./pi;
        
        akvec = zeros(n+1,1); %initialize output matrix
        akvec(1) = (omubar - omlbar) / (pi) ;               % c_0
        
        kk=1;
        while kk <=n; %loop over specified k's to construct filter weights
            akvec(kk+1) = ( sin(kk*omubar)-sin(kk*omlbar) ) / (kk*pi); %construct  c_j = (j pi)^-1 [ sin(j w_upper) - sin(j w_lower)]  (see Watson 2007)
            kk = kk+1;
        end
        
        %{ 
          Impose constraint that transfer is
              (i)  0 at om = 0  if oml > 0;
              (ii) 1 at om = 1  if oml ==0;
          This amounts to requiring that weights sum to zero.
          Initial sum of weights:
        %}
        lam = akvec(1) + 2 * sum( akvec(2:n+1) );
        
        % Amount to add to each weight to get sum to add to zero
        if (omlbar > 0.00000001);
            lam = - lam/(2*(n+1));
        else;
            lam = (1-lam)/(2*(n+1));
        end
        akvec = akvec + lam;
        akvec(1) = akvec(1) + lam;
        
        %Set vector of weights
        
        avec = zeros(2*n +1,1);
        avec(n+1) = akvec(1);
        i=1;
        while i <= n;
            avec(n+1-i) = akvec(i+1);
            avec(n+1+i) = akvec(i+1);
            i = i+1;
        end
    end
