% Figure 4:  Plot Urate a variety of ways

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';

  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  calvec_r = calvec_qr;
  urate = 100*urate;
  u_gap_cbo = urate - u_nr;
  
  % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  
  % Construct transformations of urate
  u_gap_cbo_ma4 = ma(u_gap_cbo,4);
  u_yoy = dif(ma(urate,4),4);
  [u_bp tmp] = bpassar(urate,updc,lpdc,n,nar,tcode,seflag);
  ii = isnan(urate);
  tmp = urate(ii==0);
  hp_trend_wght = hp_weights(size(tmp,1),1600);
  tmp_hp = tmp - hp_trend_wght*tmp;
  u_hp = NaN(size(urate));
  u_hp(ii==0) = tmp_hp;

  figure;
  ismpl = smpl(calvec_r,[1961 1],[2019 1],4);
  ax_fs = 40;
  plot(calvec_r(ismpl==1),u_gap_cbo(ismpl==1),'- k','LineWidth',4);
  hold on;
    plot(calvec_r(ismpl==1),u_hp(ismpl==1),'-- b','LineWidth',4);
    plot(calvec_r(ismpl==1),u_bp(ismpl==1),': g','LineWidth',4);
    plot(calvec_r(ismpl==1),u_yoy(ismpl==1),'-. r','LineWidth',4);
  hold off;
  xlim([1970 2020]);
  ax = gca;
  ax.FontSize = ax_fs;
  legend('Unemployment gap (CBO)','Unemployment rate (HP)','Unemployment rate (BP)','Unemployment rate (YoY)','Location','North');
  set(gcf, 'Position', get(0, 'Screensize'));  % Full Screen
  %columnlegend(2,str_title,'Location','SouthWest','boxon');
  figure_to_png(figdir,'Figure_4');
  close(gcf);
  
  path(p1);
