% Figure 5, 6 and 7


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
p2 = path(p1,'../m_utilities');
path(p2,'../m_utilities/simonhenin-columnlegend-8883602');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  calvec_r = calvec_qr;
  calds_r = calds_qr;
  dnobs_r = dnobs_qr;
  
  % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  
  % Real Variables
  log_gdo = 0.5*log(gdp)+0.5*log(gdi);
  if isnan(gdi(end)) == 1;  % Last observation is missing, use GDP growth for last entry;
      log_gdo(end) = log_gdo(end-1) + log(gdp(end)) - log(gdp(end-1));
  end;
  yvar = log_gdo;  labelvec_r = {'GDO (log)'};
  yvar = [yvar capu]; labelvec_r = [labelvec_r;'Capacity utilization'];
  yvar = [yvar log(emp_est)]; labelvec_r = [labelvec_r;'Employment (log)'];
  yvar = [yvar emp_pop]; labelvec_r = [labelvec_r;'Employment/Population'];
  yvar = [yvar emp2554_pop]; labelvec_r = [labelvec_r;'Employment/Population (age 25-54)'];
  yvar = [yvar -urate]; labelvec_r = [labelvec_r;'Unemployment rate ({\times} -1)'];
  yvar = [yvar -urate_st]; labelvec_r = [labelvec_r;'Short-term unemployment rate ({\times} -1)'];
  
  n_activity = size(yvar,2);
 
  yvar_bp = NaN(size(yvar));
  yvar_yoy = NaN(size(yvar));
  for i = 1:n_activity;
      [xbp tmp] = bpassar(yvar(:,i),updc,lpdc,n,nar,tcode,seflag);
      yvar_bp(:,i) = xbp;
      yvar_yoy(:,i) = dif(ma(yvar(:,i),4),4);
  end;
  
% Plot Activity Variables
  ax_fs = 25;
  figure;
  pan = {'(a) ';'(b) ';'(c) ';'(d) ';'(e) ';'(f) '};
  ismpl = smpl(calvec_r,[1961 1],[2019 1],4);
  for i = 1:6;
      ss = char(labelvec_r(i));
      ssp = char(pan(i));
      tmp1 = standardize(yvar_bp(ismpl==1,end));
      tmp2 = standardize(yvar_bp(ismpl==1,i));
      subplot(3,2,i);
      plot(calvec_r(ismpl==1),tmp1,'-- b','LineWidth',3);
      hold on;
        plot(calvec_r(ismpl==1),tmp2,'- k','LineWidth',3);
      hold off;
      if i == 1
         legend('short-term unemployment rate ({\times} -1) ','cyclical activity measure','Location','northeast');
      end
      xlim([1960 2020]);
      sss = ['' ssp ss];
      title(sss);
      ax = gca;
      ax.FontSize = ax_fs;   
  end;
  figure_to_png(figdir,'Figure_5_6Panels');
  close(gcf);
  
  % Estimate CAI 
  
  % Lags used in PC
  pc_lag = [2 2 0 0 0 0 2]';

  % List variables used and lags
  fprintf('Using real variables: \n');
  for i = 1:n_activity;
        str = char(labelvec_r(i));
        str = [str '  lags =' num2str(pc_lag(i)) '\n'];
        fprintf(str);
  end;
  
  % Form variable matrix for PC;
  ypc_data = NaN(size(yvar_bp));
  ypc_data_yoy = NaN(size(yvar_yoy));
  jj = 1;
  for i = 1:size(yvar,2);
        ypc_data(:,jj) = lag(yvar_bp(:,i),pc_lag(i));
        ypc_data_yoy(:,jj) = lag(yvar_yoy(:,i),pc_lag(i));
        jj = jj+1;
  end;
  
  nfirst = [1961 1];
  nlast = [2019 1];
  
  % Compute first PC using possibly unbalanced panel
  est_par.smpl_par.calvec = calvec_r;
  est_par.smpl_par.nfirst = nfirst;
  est_par.smpl_par.nlast = nlast;
  est_par.smpl_par.nper = 4;
  % Factor analysis parameters
  est_par.fac_par.nt_min                  = 20;     % min number of obs for any series used to est factors
  est_par.fac_par.tol                     = 10^-8;  % precision of factor estimation (scaled by by n*t)
  est_par.fac_par.lambda_constraints_est = 1;       % no constraints
  est_par.fac_par.nfac.unobserved = 1;
  est_par.fac_par.nfac.observed = 0;
  est_par.fac_par.nfac.total = 1;
  lsout = factor_estimation_ls(ypc_data, est_par);
  fac = lsout.fac;
  cai = (fac - mean(packr(fac)))/std(packr(fac));
  % Save CAI
  str = [matdir 'cai'];save(str,'cai');
  
  %yoy
  lsout_yoy = factor_estimation_ls(ypc_data_yoy, est_par);
  fac = lsout_yoy.fac;
  cai_yoy = (fac - mean(packr(fac)))/std(packr(fac));
  str = [matdir 'cai_yoy'];save(str,'cai_yoy');
  
 
  ismpl = smpl(calvec_r,nfirst,nlast,4);
  ypc_data_std = NaN(size(ypc_data));
  for i = 1: n_activity
      ypc_data_std(ismpl==1,i) = standardize(ypc_data(ismpl==1,i));
  end;
  
  %Plot PC and output measures
  figure;
  ax_fs = 30;
  plot(calvec_r,cai,'- k','LineWidth',5);
  hold on;
    plot(calvec_r,ypc_data_std(:,1),'-- b','LineWidth',2);
    plot(calvec_r,ypc_data_std(:,2),': b','LineWidth',2);
    plot(calvec_r,ypc_data_std(:,3),'-- r','LineWidth',2);
    plot(calvec_r,ypc_data_std(:,4),': r','LineWidth',2);
    plot(calvec_r,ypc_data_std(:,5),'-. r','LineWidth',2);
    plot(calvec_r,ypc_data_std(:,6),'-- g','LineWidth',2);
    plot(calvec_r,ypc_data_std(:,7),': g','LineWidth',2);
  hold off;
   str_title = { ...
  	  'Cyclical activity index' ...
      'GDO (log, lagged 2 quarters)' ...
      'Capacity utilization (lagged 2 quarters)' ...
      'Employment (log)' ...
      'Employment/Population' ...
      'Employment/Population (ages 25-54)' ...
      'Unemployment rate  ({\times} -1)' ...
      'Short-term unemp. rate ({\times} -1, lagged 2 quarters)' ...
   };
  xlim([1960 2020]);
  ylim([-4 4]);
  ax = gca;
  ax.FontSize = ax_fs; 
  ax.FontSize = ax_fs;
  set(gcf, 'Position', get(0, 'Screensize'));  % Full Screen
  columnlegend(3,str_title,'Location','SouthOutside','boxon');
  figure_to_png(figdir,'Figure_6');
  close(gcf);
  
  % 
   figure;
  ax_fs = 30;
  plot(calvec_r,cai,'- k','LineWidth',4);
  hold on;
    plot(calvec_r,cai_yoy,': b','LineWidth',4);
  hold off;
  xlim([1960 2020]);
  ylim([-4 4]);
  ax = gca;
  ax.FontSize = ax_fs; 
  ax.FontSize = ax_fs;
  legend('bandpass','year-over-year');
  set(gcf, 'Position', get(0, 'Screensize'));  % Full Screen
  figure_to_png(figdir,'Figure_7');
  close(gcf);
  
  path(p1);
  
  

  