% Plot Sector 4-quarter sectoral inflation

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % -- Read in Inflation Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  pc_comp_data_calendar_m_and_q_real;
  % Data Series Used
  dp_disagg = dp_disagg_q;
  calvec_p = calvec_qp;
  calvec_r = calvec_qr;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  dp_disagg_ma4 = ma(dp_disagg,4);
  dp_agg_xfe_ma4 = ma(dp_agg_xfe_q,4);
  
  % Dates
  ismpl_p = smpl(calvec_p,[1961 1],[2019 1],4);
  
  % Plot Level of Disaggregate Inflation
  ax_fs = 20;
  figure;
  pan = {'a';'b';'c';'d';'e';'f';'g';'h';'i';'j';'k';'l';'m';'n';'o';'p';'q';'r';'s';'t'};
  for i = 1:17;
      ss = char(labelvec_disagg(i));
      subplot(6,3,i);
      plot(calvec_p(ismpl_p==1),dp_agg_xfe_ma4(ismpl_p==1),': b','LineWidth',4);
      hold on;
         plot(calvec_p(ismpl_p==1),dp_disagg_ma4(ismpl_p==1,i),'- k','LineWidth',4);
      hold off;
      xlim([1960 2020]);
      title(ss);
      ax = gca;
      ax.FontSize = ax_fs;    
  end;
  legend({'Aggregate core inflation','Sector-specific inflation'},'Position',[0.7 0.12 0.15 0.07],'FontSize',35)
  set(gcf, 'Position', get(0, 'Screensize'));  % Full Screen
  figure_to_png(figdir,'Figure_8');
  close(gcf);
  
  path(p1);
  