% Plot Sector 4-quarter sectoral inflation and CAI

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  
  % -- Read in Inflation Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  pc_comp_data_calendar_m_and_q_real;
  % Data Series Used
  dp_disagg = dp_disagg_q;
  calvec_p = calvec_qp;
  calvec_r = calvec_qr;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  dp_disagg_yoy = dif(ma(dp_disagg,4),4);
  dp_agg_xfe_ma4 = ma(dp_agg_xfe_q,4);
  
  dp_disagg_bp = NaN(size(dp_disagg));
  for i = 1:size(dp_disagg,2);
      [xbp tmp] = bpassar(dp_disagg(:,i),updc,lpdc,n,nar,tcode,seflag);
      dp_disagg_bp(:,i) = xbp;
  end;
  
  % Load CAI
  str = [matdir 'cai'];load(str);
  
  % Dates
  ismpl_p = smpl(calvec_p,[1984 1],[2019 1],4);
  ismpl_r = smpl(calvec_r,[1984 1],[2019 1],4);
  
  dp_disagg_yoy_std = NaN(size(dp_disagg_yoy));
  dp_disagg_yoy_std(ismpl_p==1,:) = (dp_disagg_yoy(ismpl_p==1,:)-mean(dp_disagg_yoy(ismpl_p==1,:)))./std(dp_disagg_yoy(ismpl_p==1,:));
  
  dp_disagg_bp_std = NaN(size(dp_disagg_bp));
  dp_disagg_bp_std(ismpl_p==1,:) = (dp_disagg_bp(ismpl_p==1,:)-mean(dp_disagg_bp(ismpl_p==1,:)))./std(dp_disagg_bp(ismpl_p==1,:));
 
  cai_std = NaN(size(cai));
  cai_std(ismpl_r==1) = standardize(cai(ismpl_r==1));
  % Plot Level of Disaggregate Inflation
  ax_fs = 20;
  figure;
  pan = {'a';'b';'c';'d';'e';'f';'g';'h';'i';'j';'k';'l';'m';'n';'o';'p';'q';'r';'s';'t'};
  for i = 1:17;
      ss = char(labelvec_disagg(i));
      subplot(6,3,i);
      plot(calvec_r(ismpl_r==1),cai_std(ismpl_r==1),': b','LineWidth',4);
      hold on;
         plot(calvec_p(ismpl_p==1),dp_disagg_yoy_std(ismpl_p==1,i),'- k','LineWidth',4);
      hold off;
      xlim([1980 2020]);
      title(ss);
      ax = gca;
      ax.FontSize = ax_fs;    
  end;
  legend({'Cyclical activity index','Sector-specific inflation'},'Position',[0.7 0.12 0.15 0.07],'FontSize',35)
  set(gcf, 'Position', get(0, 'Screensize'));  % Full Screen
  figure_to_png(figdir,'Figure_9');
  close(gcf);
  
  % Table 4
  outfile_name = [outdir 'Table_4.csv'];
  fileID = fopen(outfile_name,'w');
  fprintf(fileID,'Sector,corBP,corDIF \n');
 
  for i = 1:size(dp_disagg,2);
     xbp = dp_disagg_bp(ismpl_p==1,i);
     xyoy = dp_disagg_yoy(ismpl_p==1,i);
     y = cai(ismpl_r==1);
     cbp = cor_compute(xbp,y);
     cyoy = cor_compute(xyoy,y);
     ss = char(labelvec_disagg{i});
     fprintf(fileID,[ss ',']);
     fprintf(fileID,',%5.2f ,%5.2f \n',[cbp cyoy]);
  end;
  
  path(p1);