% Table 1 correlation and PC slopes


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
   % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  bw_bw = 60;
  nw_ma = 8;   % Newey-West truncation parameter
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  pc_comp_data_calendar_m_and_q_prices;
  calvec_r = calvec_qr;
  calvec_p = calvec_qp;
  dp_disagg = dp_disagg_q;
  
  dp_xfe = ma(dp_agg_xfe_q,4);
  d4_dp_xfe = dif(dp_xfe,4);
  
  % GDO
  log_gdo = 0.5*log(gdp)+0.5*log(gdi);
  if isnan(gdi(end)) == 1;  % Last observation is missing, use GDP growth for last entry;
      log_gdo(end) = log_gdo(end-1) + log(gdp(end)) - log(gdp(end-1));
  end;
  
  urate = urate *100;
  urate_cbo_gap = urate - u_nr;
  log_gdp_cbo_gap = log_gdo - log(gdp_pot);
  
  urate_gap = xgap_bw(urate,bw_bw);
  urate_st_gap = xgap_bw(urate_st,bw_bw);
  emp_pop_gap = xgap_bw(emp_pop,bw_bw);
  emp2554_pop_gap = xgap_bw(emp2554_pop,bw_bw);
  capu_gap = xgap_bw(capu,bw_bw);
  
  tmp = [urate_cbo_gap -log_gdp_cbo_gap urate_gap urate_st_gap -emp_pop_gap -emp2554_pop_gap -capu_gap urate urate_st];
  slack_mat = ma(tmp,4);
  str_title = { ...
      'Unemployment gap (CBO)' ...
      'GDP gap (CBO log x -1)' ...
      'Unemployment gap (two-sided filtered)' ...
      'Short-term unemployment gap (two-sided filtered)' ...
      'Employment-population ratio (x -1 two-sided filtered)' ...
      'Employment-population ratio ages 25-54 (x -1 two-sided filtered)' ...
      'Capacity utilization rate (x -1 two-sided filtered)' ...
      'Unemployment rate' ...
      'Short-term unemployment rate' ...
   }';
  
  % Standardize and then scale all variables so they have the same SD as
  % the unemployment gap over 1961-2019q1
  % Scale CAI so it has stdev as urate-gap
  ismpl = smpl(calvec_r,[1961 1],[2019 4],4);
  scl_ugap = std(urate_cbo_gap(ismpl==1));
  slack_mat_scl = NaN(size(slack_mat));
  for i = 1: size(slack_mat,2);
      x = slack_mat(ismpl==1,i);
      xs = standardize(x);
      xs = scl_ugap*xs;
      slack_mat_scl(ismpl==1,i) = xs;
  end;
  
  ismpl_p_1 = smpl(calvec_p,[1961 1],[1983 4],4);
  ismpl_p_2 = smpl(calvec_p,[1984 1],[1999 4],4);
  ismpl_p_3 = smpl(calvec_p,[2000 1],[2019 1],4);
  ismpl_r_1 = smpl(calvec_r,[1961 1],[1983 4],4);
  ismpl_r_2 = smpl(calvec_r,[1984 1],[1999 4],4);
  ismpl_r_3 = smpl(calvec_r,[2000 1],[2019 1],4);
   
  cor_mat = NaN(size(slack_mat_scl,2),3);
  bhat_mat = NaN(size(slack_mat_scl,2),3);
  se_bhat_mat = NaN(size(slack_mat_scl,2),3);
  nobs_mat = NaN(size(slack_mat_scl,2),3);
  
  ismpl_p = [ismpl_p_1 ismpl_p_2 ismpl_p_3];
  ismpl_r = [ismpl_r_1 ismpl_r_2 ismpl_r_3];
  
  for i = 1:size(slack_mat_scl,2);
      for j = 1:3;
          y = d4_dp_xfe(ismpl_p(:,j) == 1);
          x = slack_mat_scl(ismpl_r(:,j) == 1,i);
          tmp = packr([y x]);
          nobs_mat(i,j) = size(tmp,1);
          yp = tmp(:,1);
          xp = tmp(:,2);
          cor_mat(i,j) = corr(xp,yp);
          wp = [xp ones(size(xp,1),1)];
          [betahat,vbeta,se_beta,ser,rbarsq] = hac_ols(yp,wp,nw_ma,1);
          bhat_mat(i,j) = betahat(1);
          se_bhat_mat(i,j) = se_beta(1);
      end;
  end;
  
 % Save Results to CSV file
 
 % Some Dates
 date_mat = NaN(3,2);
 for j = 1:3;
     tmp = calvec_r(ismpl_r(:,j) == 1);
     date_mat(j,1) = min(tmp);
     date_mat(j,2) = max(tmp);
 end;
 
 outfile_name = [outdir 'Table_1.csv'];
 fileID = fopen(outfile_name,'w');
 fprintf(fileID,'Slack Measure,,cor,,,bhat (sebhat),,\n');
 tmp = [date_mat(1,:) date_mat(2,:) date_mat(3,:)];
 fprintf(fileID,',%7.2f-%7.2f,%7.2f-%7.2f,%7.2f-%7.2f,,%7.2f-%7.2f,%7.2f-%7.2f,%7.2f-%7.2f \n',[tmp tmp]);
 for i = 1:size(slack_mat_scl,2);
     ss = char(str_title{i});
     fprintf(fileID,[ss ',']);
     prtmat_comma(cor_mat(i,:),fileID,'%6.2f',',,');
     for j = 1:3;
        fprintf(fileID,'%6.2f (%5.2f),',[bhat_mat(i,j) se_bhat_mat(i,j)]); 
     end;
     fprintf(fileID,'\n'); 
 end;
 
 path(p1);
 