% Scatter plots with inflation


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  ex_wght_hl = 60;
  nw_ma = 4;   % Newey-West truncation parameter
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  pc_comp_data_calendar_m_and_q_prices;
  calvec_r = calvec_qr;
  calvec_p = calvec_qp;
  
  % GDO
  log_gdo = 0.5*log(gdp)+0.5*log(gdi);
  if isnan(gdi(end)) == 1;  % Last observation is missing, use GDP growth for last entry;
      log_gdo(end) = log_gdo(end-1) + log(gdp(end)) - log(gdp(end-1));
  end;
  
  dp_xfe = ma(dp_agg_xfe_q,4);
  d4_dp_xfe = dif(dp_xfe,4);
  
  urate = urate *100;
  
  % Compute real time gaps
  ex_wght = exp(log(0.5)/ex_wght_hl);
  urate_gap = xgap_ex1s(urate,ex_wght);
  urate_st_gap = xgap_ex1s(urate_st,ex_wght);
  emp_pop_gap = xgap_ex1s(emp_pop,ex_wght);
  emp2554_pop_gap = xgap_ex1s(emp2554_pop,ex_wght);
  capu_gap = xgap_ex1s(capu,ex_wght);
  slack_mat = [urate urate_st urate_gap urate_st_gap -emp_pop_gap -emp2554_pop_gap -capu_gap];
  
  str_title = { ...
      'Unemployment rate' ...
      'Short-term unemployment rate' ...
      'Unemployment rate (real-time gap)' ...
      'Short-term unemployment rate  (real-time gap)' ...
      'Employment-population ratio (real-time gap)' ...
      'Employment-population ratio ages 25-54 (real-time gap)' ...
      'Capacity utilization rate (real-time gap)' ...
     };
  
   
   sup_wald_mat = NaN(size(slack_mat,2),2);
   % Compute Sup_Wald Statistics
   ismpl_r = smpl(calvec_r,[1984 1],[2019 1],4);
   ismpl_p = smpl(calvec_p,[1984 1],[2019 1],4);
   for i = 1:size(slack_mat,2);
       y = d4_dp_xfe;
       ylag_4 = lag(y,4);
       x = slack_mat(:,i);
       xlag_4 = lag(x,4);
       yp = y(ismpl_p==1);
       xp = [xlag_4(ismpl_r==1) ylag_4(ismpl_p==1)];
       xp = [ones(size(xp,1),1) xp];
       [lm,lmr,lsbreak,lr,lrr]=qlra(yp,1,xp,0.15,nw_ma);
       sup_wald_mat(i,1) = lmr/size(xp,2);  % F-statistic form
       sup_wald_mat(i,2) = pval_qlr(lmr,size(xp,2),0.15);
   end;
   
   % Pseudo-out-of-sample forecasts
   % Baseline forecasts using inflation only
   y = d4_dp_xfe;
   ylag_4 = lag(y,4);
   ismpl_p_is = smpl(calvec_p,[1983 1],[2007 1],4);
   ismpl_p_os = smpl(calvec_p,[2008 1],[2019 1],4);
   yp_is = y(ismpl_p_is == 1);
   yp_os = y(ismpl_p_os == 1);
   xp = [ones(size(ylag_4,1),1) ylag_4];
   xp_is = xp(ismpl_p_is == 1,:);
   xp_os = xp(ismpl_p_os == 1,:);
   b = xp_is\yp_is;
   yp_fcst = xp_os*b;
   e_fcst = yp_os-yp_fcst;
   rmse_benchmark = sqrt(mean(e_fcst.^2)); 
   
   rel_rmse_mat = NaN(size(slack_mat,2),1);
   ismpl_r_is = smpl(calvec_r,[1983 1],[2007 1],4);
   ismpl_r_os = smpl(calvec_r,[2008 1],[2019 1],4);
   for i = 1:size(slack_mat,2); 
       y = d4_dp_xfe;
       ylag_4 = lag(y,4);
       x = slack_mat(:,i);
       xlag_4 = lag(x,4);
       yp_is = y(ismpl_p_is == 1);
       yp_os = y(ismpl_p_os == 1);
       ylag_4_is = ylag_4(ismpl_p_is==1);
       xlag_4_is = xlag_4(ismpl_r_is==1);
       ylag_4_os = ylag_4(ismpl_p_os==1);
       xlag_4_os = xlag_4(ismpl_r_os==1);
       xp_is = [xlag_4_is ylag_4_is];
       xp_os = [xlag_4_os ylag_4_os];
       xp_is = [ones(size(xp_is,1),1) xp_is];
       xp_os = [ones(size(xp_os,1),1) xp_os];
       b = xp_is\yp_is;
       yp_fcst = xp_os*b;
       e_fcst = yp_os-yp_fcst;
       rmse = sqrt(mean(e_fcst.^2)); 
       rel_rmse_mat(i) = rmse/rmse_benchmark;
   end;
      
 outfile_name = [outdir 'Table_2.csv'];
 fileID = fopen(outfile_name,'w');
 fprintf(fileID,'Slack Measure,,QLR (pvalue),relRMSE,,\n');
 
 for i = 1:size(slack_mat,2);
     ss = char(str_title{i});
     fprintf(fileID,[ss ',']);
     fprintf(fileID,',%7.2f (%7.2f),%7.2f \n',[sup_wald_mat(i,:) rel_rmse_mat(i)]);
 end;
 
 % Dates Used;
 fprintf(fileID,'Dates Uses: \n');
 fprintf(fileID,'QLR: \n');
 tmp_1 = min(calvec_p(ismpl_p==1));
 tmp_2 = max(calvec_p(ismpl_p==1)); 
 fprintf(fileID,'Inflation: %7.2f - %7.2f \n',[tmp_1 tmp_2]);
 tmp_1 = min(calvec_r(ismpl_r==1));
 tmp_2 = max(calvec_r(ismpl_r==1)); 
 fprintf(fileID,'Slack: %7.2f - %7.2f \n',[tmp_1 tmp_2]);
 fprintf(fileID,'\n POOS: \n');
 fprintf(fileID,'In-sample: \n');
 tmp_1 = min(calvec_p(ismpl_p_is==1));
 tmp_2 = max(calvec_p(ismpl_p_is==1)); 
 fprintf(fileID,'Inflation: %7.2f - %7.2f \n',[tmp_1 tmp_2]);
 tmp_1 = min(calvec_r(ismpl_r_is==1));
 tmp_2 = max(calvec_r(ismpl_r_is==1)); 
 fprintf(fileID,'Slack: %7.2f - %7.2f \n',[tmp_1 tmp_2]);
 fprintf(fileID,'Out-of-sample: \n');
 tmp_1 = min(calvec_p(ismpl_p_os==1));
 tmp_2 = max(calvec_p(ismpl_p_os==1)); 
 fprintf(fileID,'Inflation: %7.2f - %7.2f \n',[tmp_1 tmp_2]);
 tmp_1 = min(calvec_r(ismpl_r_os==1));
 tmp_2 = max(calvec_r(ismpl_r_os==1)); 
 fprintf(fileID,'Slack: %7.2f - %7.2f \n',[tmp_1 tmp_2]);
 
 path(p1);
 
 
 
 