% Summarize results different sectoral weights .. Table 5

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rng(63761);

p1 = path;
p2 = path(p1,'../m_utilities');
path(p2,'../m_utilities/simonhenin-columnlegend-8883602');

% -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
 
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  pc_comp_data_calendar_m_and_q_real;
  % Data Series Used
  dp_disagg = dp_disagg_q;
  calvec_p = calvec_qp;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  dp_disagg_yoy = dif(ma(dp_disagg,4),4);
  
  % Read in weights
  str_tmp = [matdir 'w_logit_benchmark']; load(str_tmp);
  wght_csi_benchmark = w_logit;
  
  str_tmp = [matdir 'w_logit_poorlymeasured_excluded']; load(str_tmp);
  wght_csi_pm = w_logit;
  
  str_tmp = [matdir 'w_logit_bp_inflation'];
  load(str_tmp);
  wght_csi_bp = w_logit;
  
  str_tmp = [matdir 'w_logit_20_max'];
  load(str_tmp);
  wght_csi_20max = w_logit;
  
  wght_mat = [wght_csi_benchmark wght_csi_pm wght_csi_bp wght_csi_20max];
  
  % Compute Some Share Weighted averages
  ismpl = smpl(calvec_p,[1984 1],[2019 1],4);
  share_avg = share_avg_q;
  wght_share_all = mean(share_avg(ismpl==1,:))';
  wght_mat = [wght_mat wght_share_all];
  
  share_avg_xfe = share_avg_xfe_q;
  wght_share_xfe = mean(share_avg_xfe(ismpl==1,:))';
  wght_mat = [wght_mat wght_share_xfe];
  
  wght_share_goods = zeros(17,1);
  wght_share_goods(1:8)= wght_share_all(1:8)/sum(wght_share_all(1:8));
  wght_share_services = zeros(17,1);
  wght_share_services(9:17) = wght_share_all(9:17)/sum(wght_share_all(9:17));
  wght_mat = [wght_mat wght_share_goods wght_share_services];
  
  % Forecasting weights
  mlabel = '_mucsv_tvp_17c_Q0';
  str_tmp = ['wghts_for_fig4_firstcoliscalvec' mlabel];    % Computed from updates for SW 2016
  load(str_tmp);
  calvec_pcomp = tmp(:,1);
  wghts_pcomp_date = tmp(:,2:end);
  ii = smpl(calvec_pcomp,[1984 1],[2019 1],4);
  wght_pcomp = mean(wghts_pcomp_date(ii==1,:))';
  
  wght_mat = [wght_mat wght_pcomp];
  
  dp_wght_yoy = dp_disagg_yoy*wght_mat;
  
  
  % Real Variables .. construct slack index
  % load_data = 0;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  calvec_r = calvec_qr;
  calds_r = calds_qr;
  dnobs_r = dnobs_qr;
  
  % Load CAI
  str = [matdir 'cai'];load(str);

% Construct PC -- excluding capacity utilizatioon
first_date = [1961 1];
last_date = [2019 1];
  ismpl_p_1 = smpl(calvec_p,[1961 1],[1983 4],4);
  ismpl_p_2 = smpl(calvec_p,[1984 1],[1999 4],4);
  ismpl_p_3 = smpl(calvec_p,[2000 1],[2019 1],4);
  ismpl_r_1 = smpl(calvec_r,[1961 1],[1983 4],4);
  ismpl_r_2 = smpl(calvec_r,[1984 1],[1999 4],4);
  ismpl_r_3 = smpl(calvec_r,[2000 1],[2019 1],4);
  
  cor_mat = NaN(size(wght_mat,2),3);
  ismpl_p = [ismpl_p_1 ismpl_p_2 ismpl_p_3];
  ismpl_r = [ismpl_r_1 ismpl_r_2 ismpl_r_3];
  for i = 1:size(wght_mat,2);
      for j = 1:3;
          y = dp_wght_yoy(ismpl_p(:,j) == 1,i);
          x = cai(ismpl_r(:,j) == 1);
          cor_mat(i,j) = corr(x,y);
      end;
  end;
  
  outfile_name = [outdir 'Table_5.csv'];
  fileID = fopen(outfile_name,'w');
  fprintf(fileID,'\n\n Sectors\n');
  for i = 1:17;
     ss = char(labelvec_disagg(i));
     fprintf(fileID,[ss ',']);
     fprintf(fileID,['%6.3f,'],wght_mat(i,1));
     prtmat_comma(wght_mat(i,2:end),fileID,'%6.2f','\n');
  end;
 
  fprintf(fileID,'\n');
  fprintf(fileID,'Correlations with cai over different time periods: \n');
  fprintf(fileID,'1961-1983,');
  prtmat_comma(cor_mat(:,1)',fileID,'%6.2f','\n');
  fprintf(fileID,'1984-1999,');
  prtmat_comma(cor_mat(:,2)',fileID,'%6.2f','\n');
  fprintf(fileID,'2000-2019q1,');
  prtmat_comma(cor_mat(:,3)',fileID,'%6.2f','\n');
 
  str_title = { ...
  	  'Benchmark' ...
      'Excluding poorly measured sectors' ...
      'Bandpass' ...
      'Maximum sectoral weight = 0.20' ...
   };

  ax_fs = 30;
  plot(calvec_p,dp_wght_yoy(:,1),'- k','LineWidth',4);
  hold on;
    plot(calvec_p,dp_wght_yoy(:,2),'-- b','LineWidth',3);
    plot(calvec_p,dp_wght_yoy(:,3),': r','LineWidth',3);
    plot(calvec_p,dp_wght_yoy(:,4),'-. g','LineWidth',3);
  hold off;
  ax = gca;
  ax.FontSize = ax_fs;
  set(gcf, 'Position', get(0, 'Screensize'));  % Full Screen
  columnlegend(2,str_title,'Location','NorthEast','boxon');
  figure_to_png(figdir,'Figure_14');
  close(gcf);
  
  path(p1);

 