% Table 6 and Figure 15


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  % Data Series Used
  dp_agg = dp_agg_q;
  dp_agg_xfe = dp_agg_xfe_q;
  dp_agg_xe = dp_agg_xe_q;
  dp_cpi_med = dp_cpi_med_q;
  dp_pce_tm = dp_pce_tm_q;
  dp_agg_services = dp_agg_services_q;
  dp_disagg = dp_disagg_q;
  share_avg = share_avg_q;
  share_avg_xe = share_avg_xe_q;
  share_avg_xfe= share_avg_xfe_q;
  calvec_p = calvec_qp;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  
  dp_disagg_yoy = dif(ma(dp_disagg,4),4);
  dp_agg_yoy = dif(ma(dp_agg,4),4);
  dp_agg_xfe_yoy = dif(ma(dp_agg_xfe,4),4);
  dp_agg_xe_yoy = dif(ma(dp_agg_xe,4),4);
  dp_agg_services_yoy = dif(ma(dp_agg_services,4),4);
  dp_cpi_med_yoy = dif(ma(dp_cpi_med,4),4);
  dp_pce_tm_yoy = dif(ma(dp_pce_tm,4),4);
  
  % Construct BP versions
  dp_agg_bp = bpassar(dp_agg,updc,lpdc,n,nar,tcode,seflag);
  dp_agg_xfe_bp = bpassar(dp_agg_xfe,updc,lpdc,n,nar,tcode,seflag);
  dp_agg_xe_bp = bpassar(dp_agg_xe,updc,lpdc,n,nar,tcode,seflag);
  
  dp_agg_services_bp = bpassar(dp_agg_services,updc,lpdc,n,nar,tcode,seflag);
  dp_cpi_med_bp = bpassar(dp_cpi_med,updc,lpdc,n,nar,tcode,seflag);
  dp_pce_tm_bp = bpassar(dp_pce_tm,updc,lpdc,n,nar,tcode,seflag);
 
  dp_disagg_bp = NaN(size(dp_disagg));
  for i = 1:size(dp_disagg,2);
     dp_disagg_bp(:,i) = bpassar(dp_disagg(:,i),updc,lpdc,n,nar,tcode,seflag); 
  end;
  
  % Read in CSI weights
  str_tmp = [matdir 'w_logit_benchmark']; load(str_tmp);
  wght_csi_benchmark = w_logit;
  dp_csi_yoy = dp_disagg_yoy*w_logit;
  dp_csi_bp = dp_disagg_bp*w_logit;
 
  % Plot inflation measures over 1984-2019q1
  ismpl = smpl(calvec_p,[1984 1],[2019 1],4);
  figure;
  ax_fs = 30;
  plot(calvec_p(ismpl==1),dp_csi_yoy(ismpl==1),'- k','LineWidth',3);
  hold on;
    plot(calvec_p(ismpl==1),dp_cpi_med_yoy(ismpl==1),': b','LineWidth',3);
    plot(calvec_p(ismpl==1),dp_pce_tm_yoy(ismpl==1),'-- r','LineWidth',2);
    plot(calvec_p(ismpl==1),dp_agg_xfe_yoy(ismpl==1),'- b','LineWidth',1);
  hold off;
  ax = gca;
  ax.FontSize = ax_fs;
  xlim([1980 2020]);
  legend('CSI','CPI trimmed median','PCE trimmed mean','PCE core','Location','SouthWest');
  figure_to_png(figdir,'Figure_15');
  close(gcf);
  
  % Compute Correlations
  Cormat = NaN(4,4);
  X = [dp_csi_yoy dp_cpi_med_yoy dp_pce_tm_yoy dp_agg_xfe_yoy];
  X = X(ismpl==1,:);
  for i = 1:4;
      for j = i:4;
          Y = packr([X(:,i) X(:,j)]);
          Cormat(i,j) = cor_compute(Y(:,1),Y(:,2));
      end;
  end;
  
 outfile_name = [outdir 'Table_6.csv'];
 fileID = fopen(outfile_name,'w');
 prtmat_comma(Cormat,fileID,'%5.2f','\n'); 
 
 path(p1);
 