% Table 7 Results


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
%rng(63761);

p1 = path;
path(p1,'../m_utilities');
 
 % -- File Directories  
  outdir = 'out/';
  figdir = 'fig/';
  matdir = 'mat/';
  
  % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_prices;
  % Data Series Used
  dp_agg = dp_agg_q;
  dp_agg_xfe = dp_agg_xfe_q;
  dp_agg_xe = dp_agg_xe_q;
  dp_cpi_med = dp_cpi_med_q;
  dp_pce_tm = dp_pce_tm_q;
  dp_agg_services = dp_agg_services_q;
  dp_disagg = dp_disagg_q;
  share_avg = share_avg_q;
  share_avg_xe = share_avg_xe_q;
  share_avg_xfe= share_avg_xfe_q;
  calvec_p = calvec_qp;
  dnobs_p = dnobs_qp;
  calds_p = calds_qp;
  
  dp_disagg_yoy = dif(ma(dp_disagg,4),4);
  dp_agg_yoy = dif(ma(dp_agg,4),4);
  dp_agg_xfe_yoy = dif(ma(dp_agg_xfe,4),4);
  dp_agg_xe_yoy = dif(ma(dp_agg_xe,4),4);
  dp_agg_services_yoy = dif(ma(dp_agg_services,4),4);
  dp_cpi_med_yoy = dif(ma(dp_cpi_med,4),4);
  dp_pce_tm_yoy = dif(ma(dp_pce_tm,4),4);
  
  % Construct BP versions
  dp_agg_bp = bpassar(dp_agg,updc,lpdc,n,nar,tcode,seflag);
  dp_agg_xfe_bp = bpassar(dp_agg_xfe,updc,lpdc,n,nar,tcode,seflag);
  dp_agg_xe_bp = bpassar(dp_agg_xe,updc,lpdc,n,nar,tcode,seflag);
  
  dp_agg_services_bp = bpassar(dp_agg_services,updc,lpdc,n,nar,tcode,seflag);
  dp_cpi_med_bp = bpassar(dp_cpi_med,updc,lpdc,n,nar,tcode,seflag);
  dp_pce_tm_bp = bpassar(dp_pce_tm,updc,lpdc,n,nar,tcode,seflag);
 
  dp_disagg_bp = NaN(size(dp_disagg));
  for i = 1:size(dp_disagg,2);
     dp_disagg_bp(:,i) = bpassar(dp_disagg(:,i),updc,lpdc,n,nar,tcode,seflag); 
  end;
  
  % Read in CSI weights
  str_tmp = [matdir 'w_logit_benchmark']; load(str_tmp);
  wght_csi_benchmark = w_logit;
  dp_csi_yoy = dp_disagg_yoy*w_logit;
  dp_csi_bp = dp_disagg_bp*w_logit;
  
  % Read in Real Variables
  load_data = 0;  % 1 if reloading data from Excel, etc 
  mtoq_agg = 0;   % Temporal aggregation indicator of monthly to quarterly data
  pc_comp_data_calendar_m_and_q_real;
  calvec_r = calvec_qr;
  calds_r = calds_qr;
  dnobs_r = dnobs_qr;
  urate = 100*urate;
  u_gap_cbo = urate - u_nr;
  str = [matdir 'cai'];load(str);
  cai_bp = cai;
  str = [matdir 'cai_yoy'];load(str);
  
  % BP Parameters
  n = 40;
  nar = 6;
  tcode = 1;
  seflag = 0;
  lpdc = 32;
  updc = 6;
  
  % Construct transformations of urate
  u_gap_cbo_ma4 = ma(u_gap_cbo,4);
  u_yoy = dif(ma(urate,4),4);
  [u_bp tmp] = bpassar(urate,updc,lpdc,n,nar,tcode,seflag);
  ii = isnan(urate);
  tmp = urate(ii==0);
  hp_trend_wght = hp_weights(size(tmp,1),1600);
  tmp_hp = tmp - hp_trend_wght*tmp;
  u_hp = NaN(size(urate));
  u_hp(ii==0) = tmp_hp;
  
  % Real Variables to use
  xreg_mat = [u_gap_cbo_ma4 u_bp -cai_bp -cai_yoy];
  
  % Normalize series to have the same mean and variance as u_gap_cbo_ma4
  ismpl_r = smpl(calvec_r,[1961 1],[2019 1],4);
  m = mean(u_gap_cbo(ismpl_r==1));
  s = std(u_gap_cbo(ismpl_r==1));
  
  for i = 1:size(xreg_mat,2);
     x = packr(xreg_mat(ismpl_r==1,i));
     a = mean(x);
     b = std(x);
     xreg_mat(:,i) = (xreg_mat(:,i)-a)*s/b + m;
  end;

  yreg_mat = [dp_agg_xfe_yoy dp_csi_yoy dp_csi_bp dp_cpi_med_yoy];
  
  
  labelvec_y = {...
      'pce core yoy' ...
      'csi yoy' ...
      'csi bp' ...
      'cpi median yoy' ...
  };

labelvec_x = {...
      'urate gap (cbo)' ...
      'urate bp' ...
      'cai bp' ...
      'cai yoy' ...
};

runmat = [...
    [1 1]; ...
    [1 2]; ...
    [1 3]; ...
    [2 1]; ...
    [2 2]; ...
    [2 3]; ...
    [2 4]; ...
    [3 3]; ...
    [4 1]; ...
    [4 2]; ...
    [4 3] ...
];
    

  % Sample periods
  ismpl_p_1 = smpl(calvec_p,[1961 1],[1983 4],4);
  ismpl_p_2 = smpl(calvec_p,[1984 1],[1999 4],4);
  ismpl_p_3 = smpl(calvec_p,[2000 1],[2019 1],4);
  ismpl_r_1 = smpl(calvec_r,[1961 1],[1983 4],4);
  ismpl_r_2 = smpl(calvec_r,[1984 1],[1999 4],4);
  ismpl_r_3 = smpl(calvec_r,[2000 1],[2019 1],4);
  ismpl_p = [ismpl_p_1 ismpl_p_2 ismpl_p_3];
  ismpl_r = [ismpl_r_1 ismpl_r_2 ismpl_r_3];
  
  n_r = size(runmat,1);
  n_p = size(ismpl_p,2);

  cor_mat = NaN(n_r,n_p);
  bhat_mat = NaN(n_r,n_p);
  se_bhat_maty = NaN(n_r,n_p);
  
  nw_ma = 8;   % Newey-West truncation parameter
  ikern = 1;
  for ir = 1:n_r;
      for ip = 1:n_p;
         yreg = yreg_mat(ismpl_p(:,ip)==1,runmat(ir,1));
         xreg = xreg_mat(ismpl_r(:,ip)==1,runmat(ir,2));
         tmp = packr([yreg xreg]);
         if size(tmp,1) >= 48;
             yreg = tmp(:,1);
             xreg = tmp(:,2);
             [betahat,vbeta,se_beta,ser,rbarsq] = hac_ols(yreg,[ones(size(xreg,1),1) xreg],nw_ma,ikern);
             bhat_mat(ir,ip) = betahat(2);
             se_bhat_mat(ir,ip) = se_beta(2);
             cor_mat(ir,ip) =cor_compute(yreg,xreg);
         end;
    end;
  end;
  
  outfile_name = [outdir 'Table_7.csv'];
  fileID = fopen(outfile_name,'w');
  for ir = 1:n_r;
      str = char(labelvec_y(runmat(ir,1)));
      fprintf(fileID,[str ',']);
      str = char(labelvec_x(runmat(ir,2)));
      fprintf(fileID,[str ',']);
      tmp = [cor_mat(ir,:) bhat_mat(ir,:)];
      prtmat_comma(tmp,fileID,'%6.3f','\n');
  end;
  
  path(p1);
  