% Set up data and calendars for quarterly and monthly real data in pc_comp .. 
% Construct Monthly and Quarterly Values of Inflation
% 5/15/2018, mww

if load_data == 1;

% ----------- Features of Data Set ---------
miss_code = 1.0e+32;

% ----------- Sample Period, Calendars and so forth
[dnobs_m,calvec_m,calds_m] = calendar_make([1947 1],[2019 3],12);
[dnobs_q,calvec_q,calds_q] = calendar_make([1947 1],[2019 1],4);

% --------------- Read In monthly data ---------------- 
ns = 13;
xlsname = '../data/pccomp_real.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Monthly';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs_m,ndesc,ncodes);
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);
% Replace missing values with NaN
isel = datamat == miss_code;
datamat(isel) = NaN;

% Construct Relevant Variables and give friendly names
str='TCU';    % Capacity Utilization 
str=upper(str);
j = colnumber(str,namevec);
capu_m = datamat(:,j);
capu = mtoq(capu_m,calds_m,calds_q,mtoq_agg);

str='CLF16OV';    % Civilian Labor Force 
str=upper(str);
j = colnumber(str,namevec);
labor_force_m = datamat(:,j);
labor_force = mtoq(labor_force_m,calds_m,calds_q,mtoq_agg);

str='AHETPI';    % Average Hourly Earnings of Production and Nonsupervisory Employees: Total Private
str=upper(str);
j = colnumber(str,namevec);
ahe_m = datamat(:,j);
ahe = mtoq(ahe_m,calds_m,calds_q,mtoq_agg);

str='CNP16OV';    % Population
str=upper(str);
j = colnumber(str,namevec);
population_m = datamat(:,j);
population = mtoq(population_m,calds_m,calds_q,mtoq_agg);

str='CE16OV';    % Employment: Household Survey
str=upper(str);
j = colnumber(str,namevec);
emp_hs_m = datamat(:,j);
emp_hs = mtoq(emp_hs_m,calds_m,calds_q,mtoq_agg);

str='LNS12000060';    % Employment 25-54: Household Survey
str=upper(str);
j = colnumber(str,namevec);
emp_2554_m = datamat(:,j);
emp_2554 = mtoq(emp_2554_m,calds_m,calds_q,mtoq_agg);

str='LFWA25TTUSM647N';    % Pop 25-54
str=upper(str);
j = colnumber(str,namevec);
pop_2554_m = datamat(:,j);
pop_2554 = mtoq(pop_2554_m,calds_m,calds_q,mtoq_agg);

str='PAYEMS';    % Employment: Establishment Survey 
str=upper(str);
j = colnumber(str,namevec);
emp_est_m = datamat(:,j);
emp_est = mtoq(emp_est_m,calds_m,calds_q,mtoq_agg);

str='USPRIV';    % Employment: Total Private Industries
str=upper(str);
j = colnumber(str,namevec);
emp_private_m = datamat(:,j);
emp_private = mtoq(emp_private_m,calds_m,calds_q,mtoq_agg);

str='UEMP27OV';    % Unemployed >= 27 weeks, number 
str=upper(str);
j = colnumber(str,namevec);
un_ge27_m = datamat(:,j);
un_ge27 = mtoq(un_ge27_m,calds_m,calds_q,mtoq_agg);

str='UNEMPLOY';    % Unemployed number 
str=upper(str);
j = colnumber(str,namevec);
un_total_m = datamat(:,j);
un_total = mtoq(un_total_m,calds_m,calds_q,mtoq_agg);

str='INDPRO';    % Unemployed number 
str=upper(str);
j = colnumber(str,namevec);
indprod_m = datamat(:,j);
indprod = mtoq(indprod_m,calds_m,calds_q,mtoq_agg);

urate_st = (un_total-un_ge27)./labor_force;
emp_pop = emp_hs./population;
emp2554_pop = emp_2554./pop_2554;
urate = un_total./labor_force;

% % Plot Series
% slist = {...
%            'capu' ... 
%            'labor_force' ...   
%            'population' ...
%            'emp_hs' ...
%            'emp_2554' ...
%            'emp_est' ...
%            'emp_private' ...
%            'un_ge27' ...
%            'un_total' ...
%            'indprod' ...
%          } ;
% for i = 1:size(slist,2);
%     ss = char(slist(i));
%     ss1 = [ss '_m'];
%     eval(['xq = ' ss ';']);
%     eval(['xm = ' ss1 ';']);
%     plot(calvec_m,xm);
%     hold on;
%      plot(calvec_q,xq);
%     hold off;
%     title(ss);
%     waitforbuttonpress;
%     close(gcf);
% end;
% plot(calvec_q,emp_pop);
% waitforbuttonpress;
% close(gcf);

% --------------- Read in Quarterly data ---------------- 
ns = 9;
xlsname = '../data/pccomp_real.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs_q,ndesc,ncodes);
namevec = upper(namevec);
% Eliminate any leading or trailing blanks 
namevec=strtrim(namevec);
% Replace missing values with NaN
isel = datamat == miss_code;
datamat(isel) = NaN;

str='GDI';    % nominal GDI
str=upper(str);
j = colnumber(str,namevec);
gdi_nom = datamat(:,j);

str='GDPC1';    % real GDP
str=upper(str);
j = colnumber(str,namevec);
gdp = datamat(:,j);

str='GDPDEF';    % GDP Deflator
str=upper(str);
j = colnumber(str,namevec);
pgdp = datamat(:,j);

str='GDPPOT';    % CBO Potential GDP
str=upper(str);
j = colnumber(str,namevec);
gdp_pot_cbo = datamat(:,j);

str='OUTBS';    % real output business sector
str=upper(str);
j = colnumber(str,namevec);
y_bus = datamat(:,j);

str='OUTNFB';    % real output nonfarm business sector
str=upper(str);
j = colnumber(str,namevec);
y_nfb = datamat(:,j);

str='GDPPOT';    % CBO Potential GDP
str=upper(str);
j = colnumber(str,namevec);
gdp_pot = datamat(:,j);

str='NROU';    % CBO Natural Rate of Unemployment
str=upper(str);
j = colnumber(str,namevec);
u_nr = datamat(:,j);

str='NROUST';    % CBO Natural Rate of Unemployment short term
str=upper(str);
j = colnumber(str,namevec);
u_nr_st = datamat(:,j);

gdi = gdi_nom./pgdp;  % real GDI


%  slist = {...
%            'gdi' ...
%            'gdp' ...
%            'y_bus' ...
%            'y_nfb' ...
%            'gdp_pot' ...
%            'u_nr' ...
%            'u_nr_st' ...
%           } ;
% for i = 1:size(slist,2);
%     ss = char(slist(i));
%     eval(['xq = ' ss ';']);
%     plot(calvec_q,xq);
%     title(ss);
%     waitforbuttonpress;
%     close(gcf);
% end;

calvec_qr = calvec_q;
calds_qr = calds_q;
dnobs_qr = dnobs_q;
% Save Variable Series 
  slist_real = {...
           'calvec_qr' ...
           'calds_qr' ...
           'dnobs_qr' ...
           'capu' ...
           'ahe' ...
           'indprod' ...
           'emp_est' ...
           'emp_private' ...
           'urate' ...
           'urate_st' ...
           'emp_pop' ...
           'emp2554_pop' ...
           'gdi' ...
           'gdp' ...
           'y_bus' ...
           'y_nfb' ...
           'gdp_pot' ...
           'u_nr' ...
           'u_nr_st' ...
          }';
  str_tmp = [matdir 'slist_real'];
  save(str_tmp,'slist_real');
  for iseries = 1:size(slist_real,1);
     ustr = char(slist_real(iseries));
     str_tmp = [matdir ustr];
     str_tmp1 = 'save(str_tmp,''';
     str_tmp2 = ''');';
     eval([str_tmp1 ustr str_tmp2]);
  end;

end;  %Load Data end;
   
% Load Variables and Give Standard Names 
str_tmp = [matdir 'slist_real'];
load(str_tmp); 
for iseries = 1:size(slist_real,1);
     ustr = char(slist_real(iseries));
     str_tmp = [matdir ustr];
     load(str_tmp);
end; 