# install.packages("tidyverse")
# install.packages("sf")
# install.packages("furrr")
library(tidyverse)
library(sf)
library(furrr)

# Raw Data Downloaded from "https://healthinequality.org/data/"
cz1990 <- st_read("cz1990_shapefile/cz1990.shp")
crosswalk <- read_csv("cty_cz_st_crosswalk.csv")


# Exclude Alaska and Hawaii
cz_AH <- crosswalk %>% filter(statename %in% c("Alaska","Hawaii")) %>% 
  select(cz) %>% distinct()

cz_dta <- cz1990 %>% filter(!cz %in% cz_AH$cz) %>% arrange(cz) %>% mutate(cz = as.character(cz))



# Map Illustration
ggplot() +
  geom_sf(data = cz_dta, fill = "lightblue", color = "black", size = 0.2)+
  theme_classic() +
  labs(title = "Shapefile Plot")

# Find Adjacency

plan(multisession)  # Use multiple cores for parallel processing

cz_dta <- cz_dta %>%
  st_transform(crs = 4326) %>%  # Ensure a common CRS for the spatial operations
  mutate(
    neighbor_ids = future_map(st_touches(., .), function(neighbors) {
      if (length(neighbors) > 0) {
        cz_dta$cz[unlist(neighbors)]
      } else {
        NA
      }
    })
  )

# Create Adjacency Matrix
all_nodes <- unique(cz_dta$cz)
adj_matrix <- matrix(0, nrow = length(all_nodes), ncol = length(all_nodes))
rownames(adj_matrix) <- colnames(adj_matrix) <- all_nodes
for (i in 1:nrow(cz_dta)) {
  location <- cz_dta$cz[i]
  neighbors <- cz_dta$neighbor_ids[[i]]
  adj_matrix[location, neighbors] <- 1
  adj_matrix[neighbors, location] <- 1
}


write.csv(adj_matrix, file = "CZadj_matrix.csv")



