% Find Latitude and Longitude for CZs by averaging Latitude and Longitude of FIPS in CZ

clear all;
small = 1.0e-10;
big = 1.0e+8;

% Step 1 Read in List of CZs and FIPS
X = readtable('CZ_FIPS_LL_Data.xlsx','Sheet','czlma903'); % Note .. the underlying data were copied from czlma903.xls
X_FIPS = str2num(cell2mat(X{:,'FIPS'}));
X_CZ = str2num(cell2mat(X{:,'CZ90'}));
X_POP = X.Pop1990;
CZ = unique(X_CZ);

% Step 2 Read in Latitude and Longitude for FIPS
Y = readtable('CZ_FIPS_LL_Data.xlsx','Sheet','countycenters'); % Note .. the underlying data were copied from county_centers.xlsx  
Y_FIPS = Y{:,'fips'};
Y_lon = Y{:,'clon00'};  % Geographic center in 2000
Y_lat = Y{:,'clat00'};  % Geographic center in 2000
% Note that the county_centers file is missing data for a few FIPS. The largest is Dade county. This is entered here.
Y_FIPS = [Y_FIPS; 12025];
Y_lon = [Y_lon; -80.1895];
Y_lat = [Y_lat; 25.7712];

LatLon_wght = NaN(length(CZ),2);  % Population weighted average
LatLon_unwght = NaN(length(CZ),2); % Unweighted average
N_fips = NaN(length(CZ),1);
for ic = 1:length(CZ)
  cz = CZ(ic);
  ii = X_CZ == cz;
  fips_cz = X_FIPS(ii==1);
  nfips = length(fips_cz);
  N_fips(ic) = nfips;
  pop_fips = X_POP(ii==1);
  % Select the FIPS in Y_FIPS corresponding to the fips_cz
  lat_fips = NaN(nfips,1);
  lon_fips = NaN(nfips,1);
  for il = 1:nfips
      fips = fips_cz(il);
      jj = Y_FIPS == fips;
      if sum(jj) > 0
        lat_fips(il) = Y_lat(jj==1);
        lon_fips(il) = Y_lon(jj==1);
      end
  end
  ii_miss = isnan(lat_fips);
  if sum(ii_miss) > 0
    fprintf('Warning: Missing data for CZ %6i\n',cz);
    fprintf('  Missing FIPS: %6i\n',fips_cz(ii_miss));
  end
  % Compute the weighted and unweighted averages
  lat = lat_fips(ii_miss==0);
  lon = lon_fips(ii_miss==0);
  pop = pop_fips(ii_miss==0);
  wght_fips = pop/sum(pop);
  lat_wght = sum(lat.*wght_fips);
  lon_wght = sum(lon.*wght_fips);
  lat_unwght = mean(lat);
  lon_unwght = mean(lon);
  LatLon_wght(ic,:)=[lat_wght lon_wght];
  LatLon_unwght(ic,:)=[lat_unwght lon_unwght];
  tmp = LatLon_wght(ic,:)-LatLon_unwght(ic,:);
  if max(abs(tmp(:))) > 0.5
    fprintf('Warning: Weighted and Unweighted averages differ for CZ %6i\n',cz);
    fprintf('  Weighted: %6.2f %6.2f\n',LatLon_wght(ic,1),LatLon_wght(ic,2)); 
    fprintf('  Unweighted: %6.2f %6.2f\n',LatLon_unwght(ic,1),LatLon_unwght(ic,2));
    fprintf('  Difference: %6.2f %6.2f\n',tmp(1),tmp(2));
  end
end
  
Z = table;
Z.CZ = CZ;
Z.Lat_wght = LatLon_wght(:,1);
Z.Lon_wght = LatLon_wght(:,2);
Z.Lat_unwght = LatLon_unwght(:,1);
Z.Lon_unwght = LatLon_unwght(:,2);
writetable(Z,'tmp.xlsx');  % Note .. this file is copied into a new table in CZ_FIPS_LL_Data.xlsx
