module SARmod
	use globals
	use clustermod
	implicit none
	
	real, allocatable	:: Wmat(:,:)
	
	contains

	subroutine setWmat(s)
		real, allocatable	:: s(:,:),mdata(:,:),mdata2(:,:)
		integer	:: n,l,j,i,j2
		integer, allocatable	:: inds(:),adj(:,:)
		mdata=loadcsv(trim(folder_data)//"Chetty_Data_proj.csv")
		mdata2=loadcsv(trim(folder_data)//"CZadj_matrix.csv",.true.)
		s=transpose(mdata(:,3:4))
		exo_clustids=nint(mdata(:,2))
		n=size(s,2)
		inds=[integer::]
		do l=1,n
			j=findloc(nint(mdata2(:,1)),nint(mdata(l,1)),dim=1)
			if(j==0) print *,"cannot find CZ",nint(mdata(l,1))
			inds=[inds,j]
		enddo
		Wmat=nint(mdata2(inds,1+inds))
		inds=pack([(i,i=1,n)],sum(Wmat,dim=2)>0)
		Wmat=Wmat(inds,inds)
		s=s(:,inds)
		exo_clustids=exo_clustids(inds)
		n=size(s,2)
		print *,"n=",n
		do l=1,n
			Wmat(l,:)=Wmat(l,:)/sum(Wmat(l,:))
		enddo
	end subroutine
	
end module