module testmod
	use globals
	use Sigmod
	implicit none
	
	contains

	function URtest(initflag,y,s) result(val)
		logical	:: initflag,val
		real, optional	:: y(:),s(:,:)
		integer, parameter	:: q=15
		real, allocatable, save		:: W(:,:)
		real, save		:: Om1i(q,q),Om0i(q,q),cv
		real	:: Om1(q,q),Om0(q,q),Om1chol(q,q),Om0chol(q,q)
		real	:: c1l,c1u,c,get,z(q)
		integer	:: j,l
		if(initflag) then
			W=getWeigen(getLevySig(s),q)
			W=W(:,2:)
			Om0=matmul(transpose(W),matmul(getLevySig(s),W))
			Om0chol=choleski(Om0)
			Om0i=invertpd(Om0)
			c1l=getavc_c(0.5,0,s)
			c1u=getavc_c(0.01,0,s)
			do j=1,10
				if(getpower()>.5) then
					c1u=c
				else
					c1l=c
				endif
			enddo
			print *,"final power",getpower()
			val=.true.
			return
		endif
		z=matmul(transpose(W),y)
		val=sum(z*matmul(Om0i,z))/sum(z*matmul(Om1i,z))>cv
			
		contains
			function getpower() result(val)
				integer, parameter	:: nsim=10000
				real	:: val,stats(nsim)
				c=.5*(c1l+c1u)
				Om1=matmul(transpose(W),matmul(getcSig(c,s),W))
				Om1chol=choleski(Om1)
				Om1i=invertpd(Om1)
				call rnset(10323)
				do l=1,nsim
					call rnnoa(z)
					z=matmul(Om0chol,z)
					stats(l)=sum(z*matmul(Om0i,z))/sum(z*matmul(Om1i,z))
				enddo
				cv=quantile_s(stats,.95)
				do l=1,nsim
					call rnnoa(z)
					z=matmul(Om1chol,z)
					stats(l)=sum(z*matmul(Om0i,z))/sum(z*matmul(Om1i,z))
				enddo
				val=real(count(stats>cv))/nsim
			end function
	end function
			
	function LFST(initflag,y,s) result(val)
		logical	:: initflag,val
		real, optional	:: y(:),s(:,:)
		integer, parameter	:: q=15
		real, allocatable, save		:: W(:,:)
		real, save		:: Om1i(q,q),Om0i(q,q),cv
		real	:: Om1(q,q),Om0(q,q),Om1chol(q,q),Omchol(q,q)
		real	:: g1l,g1u,g,get,z(q)
		integer	:: j,l
		if(initflag) then
			W=getWeigen(getLevySig(s),q)
			W=W(:,2:)
			Om0=matmul(transpose(W),matmul(getcSig(getavc_c(0.001,0,s),s),W))
			Om0i=invertpd(Om0)
			g1l=0.0
			g1u=50.0
			do j=1,10
				if(getpower()>.5) then
					g1u=g
				else
					g1l=g
				endif
			enddo
			print *,"final power",getpower()
			val=.true.
			return
		endif
		z=matmul(transpose(W),y)
		val=sum(z*matmul(Om0i,z))/sum(z*matmul(Om1i,z))>cv
			
		contains
			function getpower() result(val)
				integer, parameter	:: nsim=10000
				real	:: val,stats(nsim),Om(q,q),c
				integer	:: j
				g=.5*(g1l+g1u)
				Om1=Om0+g**2*matmul(transpose(W),matmul(getLevySig(s),W))
				Om1chol=choleski(Om1)
				Om1i=invertpd(Om1)

				c=getavc_c(0.03,0,s)
				cv=-1E10
				do j=1,10
					Om=matmul(transpose(W),matmul(getcSig(c,s),W))
					Omchol=choleski(Om)
					call rnset(10323)
					do l=1,nsim
						call rnnoa(z)
						z=matmul(Omchol,z)
						stats(l)=sum(z*matmul(Om0i,z))/sum(z*matmul(Om1i,z))
					enddo
					cv=max(cv,quantile_s(stats,.95))
					c=c*1.5
				enddo
				do l=1,nsim
					call rnnoa(z)
					z=matmul(Om1chol,z)
					stats(l)=sum(z*matmul(Om0i,z))/sum(z*matmul(Om1i,z))
				enddo
				val=real(count(stats>cv))/nsim
			end function
	end function
end module