module clustermod
	use globals
	use kmeans
	implicit none
	
	integer, allocatable	:: exo_clustids(:)
	
	contains

	subroutine setclusters_kmeans(s,nc,clustid,s_c)
		real	::s(:,:),val(size(s,2),nc)
		integer	:: nc
		real	:: s_c(size(s,1),nc)
		integer	:: clustid(size(s,2)),ifault,i
		
		do i=1,10
			call KMPP(s, s_c, clustid, ifault)
			if(ifault==0) exit
		end do
		if(ifault>0) then
			print *,"kmeans doesn't converge; exiting"
			stop
		endif
	end subroutine
	
	subroutine setclusters_states(s,nc,clustid,s_c)
		integer :: nc
		real			:: s(:,:)
		real, allocatable,optional	:: s_c(:,:)
		integer		:: clustid(size(s,2))
		integer	:: i,j,cnc
		cnc=0
		do i=1,size(s,2)
			j=findloc(exo_clustids(1:i-1),exo_clustids(i),dim=1)
			if(j==0) then
				cnc=cnc+1
				j=cnc
			else
				j=clustid(j)
			endif
			clustid(i)=j
		enddo
		nc=cnc
		if(.not. present(s_c)) return
		if(allocated(s_c)) deallocate(s_c)
		allocate(s_c(size(s,1),nc))
		s_c=0
		do i=1,size(s,2)
			j=clustid(i)
			s_c(:,j)=s_c(:,j)+s(:,i)
		enddo
		do j=1,nc
			s_c(:,j)=s_c(:,j)/count(clustid==j)
		enddo
	end subroutine

end module