module runmod
!!dir$ nooptimize	
	use clustermod
	use scpcmod
	use testmod
	implicit none
	
	integer, parameter	:: nsim=10000
	real, parameter		:: avc0=0.03
	real, allocatable	:: CSCPC_Sigs(:,:,:)
	logical				:: pflag=.true.
	character(len=20)	:: dgpname
	
	contains
	
	
	function getHRs2(x,nc,clustid) result(val)
		real	:: x(:),val
		integer	:: nc,clustid(:)
		real	:: v(nc)
		integer	:: j
		v=0
		do j=1,size(x)
			v(clustid(j))=v(clustid(j))+x(j)
		enddo
		val=sum(v**2)
	end function
	
	subroutine clusterFE(iflag,s,y,xZ)
		use rlse_int
		use tin_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		
		character(len=15), parameter	:: name="clustFE"
		integer, parameter	:: nncs=6
		integer				:: ncs(nncs)=[0,30,60,120,240,360]
		integer, save	:: n,k
		real, save	:: RP(6,nncs,nsim) 
		type scpc_type
			integer	:: q,n
			real	:: cv,c0
			integer, allocatable:: clustid(:),clustn(:)
			real, allocatable	:: s(:,:), W(:,:),Sigs(:,:,:)
		end type
		type(scpc_type), save	:: sd(nncs)
		
		integer	:: j,i,nc,l
		real	:: yt(size(y)),xZt(size(xZ,1),size(xZ,2)),e(size(y)),del,s2,b(size(xZ,2)),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			do j=1,nncs
				nc=ncs(j)
				if(allocated(sd(j)%s)) deallocate(sd(j)%s,sd(j)%clustid,sd(j)%clustn)
				allocate(sd(j)%s(2,nc),sd(j)%clustid(n))
				if(j==1) then
					call setclusters_states(s,nc,sd(j)%clustid,sd(j)%s)
					ncs(j)=nc
				else
					call setclusters_kmeans(s,nc,sd(j)%clustid,sd(j)%s)
				endif
				allocate(sd(j)%clustn(nc))
				do i=1,nc
					sd(j)%clustn(i)=count(sd(j)%clustid==i)
				enddo
				sd(j)%c0=getavc_c(0.03,0,sd(j)%s)
				sd(j)%W=getWeigen(getcSig(sd(j)%c0,sd(j)%s),min(qmax,nc-1))
				call setSCPCqcv(sd(j)%W,sd(j)%s,sd(j)%c0,sd(j)%q,sd(j)%cv)
				sd(j)%Sigs=getOmsSigs(sd(j)%s,sd(j)%c0)
			enddo
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			do j=1,nncs
				nc=ncs(j)
				yt=y
				xZt=xZ
				do i=1,nc
					where(sd(j)%clustid==i) yt=yt-sum(yt,mask=sd(j)%clustid==i)/sd(j)%clustn(i)
					do l=1,k
						where(sd(j)%clustid==i) xzt(:,l)=xzt(:,l)-sum(xzt(:,l),mask=sd(j)%clustid==i)/sd(j)%clustn(i)
					enddo
				enddo
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
				
				call rlse(yt,xZt,b,intcep=0)
				s2=getHRs2((yt-matmul(xZt,b))*xZt(:,1),nc,sd(j)%clustid)
				RP(1,j,iflag)=boole(sum(xZt(:,1)*yt)**2>1.96**2*s2)
				RP(2,j,iflag)=2*1.96*sqrt(s2)/sum(xZt(:,1)**2)
				
				if(allocated(Wx)) deallocate(Wx,Weta)
				allocate(Wx(n,size(sd(j)%W,2)),Weta(nc,size(sd(j)%W,2)))
				call setWxeta_clust(sd(j)%W,xZt,Wx,Weta,nc,sd(j)%clustid)
				
				s2=sum(matmul(yt,Wx(:,2:))**2)
				RP(3,j,iflag)=boole(sum(Wx(:,1)*yt)**2>sd(j)%cv**2*s2)
				RP(4,j,iflag)=2*sd(j)%cv*sqrt(s2)/sum(xZt(:,1)**2)

				ccv=getcvfromOms(getOmsfromSigs(Weta,sd(j)%Sigs),size(Weta,2)-1,level)				
				ccv=max(sd(j)%cv,ccv)
				RP(5,j,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
				RP(6,j,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			call savematcsv(trim(folder_out)//trim(dgpname)//"_"//trim(name)//".csv",sum(RP,dim=3)/nsim)
			if(pflag) then
				print *,name
				call mdisp(sum(RP,dim=3)/nsim)
			endif
		endif
	end subroutine
	

	subroutine regR2(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)

		character(len=25), parameter	:: name="R2"
		integer, save	:: q,n,k
		real, save	:: RP(1,1,nsim)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)+1),s2,b(size(xZ,2)+1),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			xZt(:,1:k)=xZ
			xZt(:,k+1)=1
			yt=y-sum(y)/n
			call rlse(yt,xZt,b,intcep=0)
			RP(1,1,iflag)=1-sum((yt-matmul(xZt,b))**2)/sum(yt**2)
		endif
		if(iflag==nsim+1) then
			call savematcsv(trim(folder_out)//trim(dgpname)//"_"//trim(name)//".csv",sum(RP,dim=3)/nsim)
			if(pflag) then
				print *,name
				call mdisp(sum(RP,dim=3)/nsim)
			endif
		endif
	end subroutine

	
	subroutine sqrtGLS(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)

		character(len=25), parameter	:: name="FGLS"
		real, parameter	:: weights(1)=[0.0] ![0.0,.2,.4,.6,.8]
		integer, save	:: q,n,k
		real, save	:: RP(6,size(weights),nsim)
		real, allocatable, save	:: Asqrts(:,:,:),W(:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)),s2,b(size(xZ,2)),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:),A(:,:)
		

		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			if(allocated(Asqrts)) deallocate(Asqrts)
			allocate(Asqrts(n,n,size(weights)))

			do j=1,size(weights)
				A=getLevySig(s)
				A=A+trace(A)*weights(j)/(n*(1-weights(j)))*eye(n)
				Asqrts(:,:,j)=matinvsqrt(demeanedSig(A))
			enddo
			c0=getavc_c(0.03,0,s)
			W=getWeigen(getcSig(c0,s),qmax)
			call setSCPCqcv(W,s,c0,q,cv)
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			allocate(Wx,Weta,mold=W)
			do j=1,size(weights)
				xZt=matmul(Asqrts(:,:,j),xZ)
				yt=matmul(Asqrts(:,:,j),y)
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
			
				call rlse(yt,xZt,b,intcep=0)
				s2=sum(((yt-matmul(xZt,b))*xZt(:,1))**2)
				RP(1,j,iflag)=boole(sum(xZt(:,1)*yt)**2>1.96**2*s2)
				RP(2,j,iflag)=2*1.96*sqrt(s2)/sum(xZt(:,1)**2)
			
				call setWxeta(W,xZt,Wx,Weta)
				s2=sum(matmul(yt,Wx(:,2:))**2)
				RP(3,j,iflag)=boole(sum(Wx(:,1)*yt)**2>cv**2*s2)
				RP(4,j,iflag)=2*cv*sqrt(s2)/sum(xZt(:,1)**2)

				ccv=getcvfromOms(getOmsfromSigs(Weta,CSCPC_Sigs),size(Weta,2)-1,level)				
				ccv=max(cv,ccv)
				RP(5,j,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
				RP(6,j,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			call savematcsv(trim(folder_out)//trim(dgpname)//"_"//trim(name)//".csv",sum(RP,dim=3)/nsim)
			if(pflag) then
				print *,name
				call mdisp(sum(RP,dim=3)/nsim)
			endif
		endif
	end subroutine

	function getisodiffA(s,del) result(val)
		real	:: s(:,:),del,val(size(s,2),size(s,2))
		integer	:: i,j,n,ndel
		real	:: c,nmiss,dmat(size(s,2),size(s,2))
		integer	:: inds(size(s,2))
		n=size(s,2)
		if(del<1.0) then
			nmiss=0
			do i=1,n
				c=0
				do j=1,n
					if(i==j) cycle
					if(norm2(s(:,j)-s(:,i))>del) then
						val(i,j)=0
					else
						val(i,j)=1 
						c=c+val(i,j)
					endif
				enddo
				if(c==0) then
					val(i,i)=0
					nmiss=nmiss+1
				else
					val(i,:)=val(i,:)/c
					val(i,i)=-1
				endif
			enddo
			print *,"fraction dropped:",real(nmiss)/n
		else
			dmat=distmat(s)
			ndel=nint(del)
			val=0
			do i=1,n
				inds=sortind(dmat(:,i))
				val(i,inds(2:ndel+1))=1.0/ndel
				val(i,i)=-1
			enddo
		endif	
	end function
	
	subroutine isodiff(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		integer, parameter	:: ndels=10
		real	:: dels(ndels)=[0.03,0.04,0.05,0.08,0.1,1.0,2.0,4.0,10.0,20.0]
		character(len=25), parameter	:: name="isodiff"
		integer, save	:: q,n,k
		real, save	:: RP(4,ndels,nsim)
		real, allocatable, save	:: As(:,:,:),W(:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)),s2,b(size(xZ,2)),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			if(allocated(As)) deallocate(As,W)
			allocate(As(n,n,ndels))
			do j=1,ndels
				del=dels(j)
				As(:,:,j)=getisodiffA(s,del)
				if(maxval(abs(As(:,:,j)))==0) then
					print *,"no locations within delta"
					stop
				endif
			enddo
			c0=getavc_c(0.03,0,s)
			W=getWeigen(getcSig(c0,s),qmax)
			call setSCPCqcv(W,s,c0,q,cv)
			RP=0
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			allocate(Wx,Weta,mold=W)
			do j=1,ndels
				xZt=matmul(As(:,:,j),xZ)
				yt=matmul(As(:,:,j),y)
				if(k>1) then
					call rlse(xZt(:,1),xZt(:,2:k),b(2:k),intcep=0)
					xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:k),b(2:k))
				endif
				call setWxeta(W,xZt,Wx,Weta)
				s2=sum(matmul(yt,Wx(:,2:))**2)
				RP(1,j,iflag)=boole(sum(Wx(:,1)*yt)**2>cv**2*s2)
				RP(2,j,iflag)=2*cv*sqrt(s2)/sum(xZt(:,1)**2)
				ccv=getcvfromOms(getOmsfromSigs(Weta,CSCPC_Sigs),size(Weta,2)-1,level)				
				ccv=max(cv,ccv)
				RP(3,j,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
				RP(4,j,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
		endif
		if(iflag==nsim+1) then
			call savematcsv(trim(folder_out)//trim(dgpname)//"_"//trim(name)//".csv",sum(RP,dim=3)/nsim)
			if(pflag) then
				print *,name
				call mdisp(sum(RP,dim=3)/nsim)
			endif
		endif
	end subroutine

	subroutine notrans(iflag,s,y,xZ)
		use rlse_int
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)

		character(len=25), parameter	:: name="levels"
		integer, parameter	:: nncs=1, ncs(nncs)=[0]
		integer, allocatable, save	:: clustids(:,:)
		
		
		integer, save	:: q,n,k
		real, save	:: RP(6,1,nsim)
		real, allocatable, save	:: W(:,:)
		real, save	:: c0,cv
		
		integer	:: j
		real	:: del,yt(size(y)),xZt(size(xZ,1),size(xZ,2)+1),s2,b(size(xZ,2)+1),ccv
		real, allocatable	:: Wx(:,:),Weta(:,:)
		
		if(iflag==0) then
			n=size(s,2)
			k=size(xZ,2)
			c0=getavc_c(0.03,0,s)
			W=getWeigen(getcSig(c0,s),qmax)
			call setSCPCqcv(W,s,c0,q,cv)
			RP=0
			if(allocated(clustids)) deallocate(clustids)
			allocate(clustids(n,nncs))
			j=1
			call setclusters_states(s,ncs(j),clustids(:,j))
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			j=1
			allocate(Wx,Weta,mold=W)
			xZt(:,1:k)=xZ
			xZt(:,k+1)=1
			call rlse(xZt(:,1),xZt(:,2:),b(2:),intcep=0)
			xZt(:,1)=xZt(:,1)-matmul(xZt(:,2:),b(2:))
			call setWxeta(W,xZt,Wx,Weta)
			yt=y
			s2=sum(matmul(yt,Wx(:,2:))**2)
			RP(1,:,iflag)=boole(sum(Wx(:,1)*yt)**2>cv**2*s2)
			RP(2,:,iflag)=2*cv*sqrt(s2)/sum(xZt(:,1)**2)
			
			ccv=getcvfromOms(getOmsfromSigs(Weta,CSCPC_Sigs),size(Weta,2)-1,level)				
			ccv=max(cv,ccv)
			RP(3,:,iflag)=boole(sum(Wx(:,1)*yt)**2>ccv**2*s2)
			RP(4,:,iflag)=2*ccv*sqrt(s2)/sum(xZt(:,1)**2)
			
			call rlse(yt,xZt,b,intcep=0)
			do j=1,nncs
				s2=getHRs2((yt-matmul(xZt,b))*xZt(:,1),ncs(j),clustids(:,j))
				RP(5,j,iflag)=boole(sum(xZt(:,1)*yt)**2>1.96**2*s2)
				RP(6,j,iflag)=2*1.96*sqrt(s2)/sum(xZt(:,1)**2)
			enddo
			
		endif
		if(iflag==nsim+1) then
			call savematcsv(trim(folder_out)//trim(dgpname)//"_"//trim(name)//".csv",sum(RP,dim=3)/nsim)
			if(pflag) then
				print *,name
				call mdisp(sum(RP,dim=3)/nsim)
			endif
		endif
	end subroutine
	
		
	subroutine tests(iflag,s,y,xZ)
		integer	:: iflag
		real	:: s(:,:),xZ(:,:),y(:)
		character(len=25), parameter	:: name="tests"
		real, save	:: RP(2,1,nsim)
		
		if(iflag==0) then
			RP=0
			return
		endif
		if(iflag>0.and.iflag<=nsim) then
			RP(1,1,iflag)=URtest(.false.,y=y)
			RP(2,1,iflag)=LFST(.false.,y=y)
		endif
		if(iflag==nsim+1) then
			call savematcsv(trim(folder_out)//trim(dgpname)//"_"//trim(name)//".csv",sum(RP,dim=3)/nsim)
			if(pflag) then
				print *,name
				call mdisp(sum(RP,dim=3)/nsim)
			endif
		endif
	end subroutine

	subroutine go(l,s,y,xZ)
		integer	:: l
		real	:: s(:,:),y(:),xz(:,:)
		call regR2(l,s,y,xZ)
		call tests(l,s,y,xZ)
		call notrans(l,s,y,xZ)
		call isodiff(l,s,y,xZ)
		call clusterFE(l,s,y,xZ)
		call sqrtGLS(l,s,y,xZ)
	end subroutine
	
	subroutine runMC(s)
		use SARmod
		real		:: s(:,:)
		integer		:: n,l,istate,k,i,im,ic
		
		real, allocatable	:: Sig0(:,:),chol0(:,:),xZ(:,:),y(:)
		real	:: c0
		character(len=40)	:: modelname
		
		n=size(s,2)
		pflag=.true.
		do k=1,1
		do im=1,9
			if(allocated(y)) deallocate(y,xZ)
			allocate(y(n),xZ(n,k))
			c0=getavc_c(0.03,0,s)
			call setOmsSigs(s,c0,CSCPC_Sigs)
!			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
!			print *,"c0=",c0
			select case(im)
				case(1)
					Sig0=getLevySig(s)
					modelname="pure Levy"
					dgpname="Levy_k"//convtos(k)
						
				case(2)
					Sig0=getI1Sig(s,c0)
					modelname="I1 with c_0.03"
					dgpname="I1003_k"//convtos(k)
				case(3)
					c0=getavc_c(0.01,0,s)
					Sig0=getI1Sig(s,c0)
					modelname="I1 with c_0.01"
					dgpname="I1001_k"//convtos(k)
				case(4)
					c0=getavc_c(0.50,0,s)
					Sig0=getcSig(c0,s)
					modelname="pure LTU with c_0.50"
					dgpname="LTU500_k"//convtos(k)
				case(5)
					Sig0=getBMSig(s)
					modelname="pure Brownian sheet"
					dgpname="Bsheet_k"//convtos(k)
				case(6)
					c0=getavc_c(0.03,2,s)
					Sig0=getI1matSig(s,c0)
					modelname="I1 with Matern B (nu=2.5) and c_0.03"
					dgpname="I1mat_k"//convtos(k)
				case(7)
					c0=getavc_c(0.03,0,s)
					Sig0=getcSig(c0,s)
					modelname="pure LTU with c_0.03"
					dgpname="LTU003_k"//convtos(k)
				case(8)
					Sig0=eye(n)-0.99*Wmat
					Sig0=invertpd(matmul(transpose(Sig0),Sig0))
					modelname="SAR099"
					dgpname="SAR099_k"//convtos(k)
				case(9)
					Sig0=eye(n)-0.999*Wmat
					Sig0=invertpd(matmul(transpose(Sig0),Sig0))
					modelname="SAR999"
					dgpname="SAR999_k"//convtos(k)
			end select
			chol0=robchol(Sig0)
!			chol0=choleski(Sig0)
			call go(0,s,y,xZ)
!$omp parallel do
			do i=1,100
				call rnset(49184*i)
			enddo
			
!$omp parallel do private(i) firstprivate(y,xZ)
			do l=1,nsim
				call rnnoa(y)
				y=matmul(chol0,y)
				y=y-sum(y)/n
				y=y/norm2(y)
				do i=1,k
					call rnnoa(xZ(:,i))
					xZ(:,i)=matmul(chol0,xZ(:,i))
					xZ(:,i)=xZ(:,i)-sum(xZ(:,i))/n
					xZ(:,i)=xZ(:,i)/norm2(xZ(:,i))
				enddo
				call go(l,s,y,xZ)
			enddo
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
			print *,"XXXXXXXXXX k=",k,"  ",modelname
			print *,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
			call go(nsim+1,s,y,xZ)
			call printtime
		enddo
		enddo
	end subroutine

	
end module
	
	
program mfort
	use runmod
	use SARmod
	use testmod
	use omp_lib
	implicit none
	integer	:: i,j,l
	real, allocatable	:: mdata(:,:),s(:,:),s_c(:,:)
	integer, allocatable	:: inds(:)
	logical	:: dum

	call initmaterngrid
	
	call omp_set_num_threads(48)
	call rnset(14)
!$omp parallel do
	do i=1,100
		call rnset(49184*i)
	enddo

	call inittime
		
	call mkGQxw(GQxw)
	
	
	call setWmat(s)		! set Wmat and s
	s=s/maxval(distmat(s))
	disttype=0
	dum=URtest(.true.,s=s)	! initialize tests
	dum=LFST(.true.,s=s)
	print *,"n=",size(s,2)
	call runMC(s)	! run MC
end program