(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31398,        673]
NotebookOptionsPosition[     29478,        632]
NotebookOutlinePosition[     29920,        649]
CellTagsIndexPosition[     29877,        646]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"path", "=", 
  "\"\<c:/dropbox/mystuff/spatialur/replication/data/\>\""}]], "Input",
 CellChangeTimes->{{3.923674310856361*^9, 3.9236743369114285`*^9}, {
  3.9237286741899567`*^9, 
  3.9237286766847777`*^9}},ExpressionUUID->"0a252a8b-ffd8-4b00-8b98-\
a3fad51bca0e"],

Cell[BoxData["\<\"c:/dropbox/mystuff/spatialur/data/\"\>"], "Output",
 CellChangeTimes->{3.923674379700382*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"638f6ecf-ae47-422f-8934-7f495dece0dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ssr", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{"path", "<>", "\"\<Chetty_Data_contiguousUS.csv\>\""}], "]"}], 
    "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "ssr", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ss", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ssr", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", 
        RowBox[{"4", ";;", "5"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mm", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "ss", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "ss", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "ss", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "ss", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"midss", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Total", "[", 
      RowBox[{"mm", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
     RowBox[{"Total", "[", 
      RowBox[{"mm", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "/", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mtr", "[", "sx_", "]"}], ":=", 
  RowBox[{
   RowBox[{"GeoGridPosition", "[", 
    RowBox[{
     RowBox[{"GeoPosition", "[", "sx", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<TransverseMercator\>\"", ",", 
       RowBox[{"\"\<Centering\>\"", "\[Rule]", "midss"}]}], "}"}]}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.911469815526883*^9, 3.9114698682237625`*^9}, 
   3.9114699388073826`*^9, {3.9114699713834705`*^9, 3.911470009319602*^9}, {
   3.921167284035918*^9, 3.921167303155789*^9}, {3.921329521605446*^9, 
   3.921329546245613*^9}, {3.9213308997250667`*^9, 3.921330904087113*^9}, {
   3.923674327021117*^9, 3.923674331535887*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"909c844e-a469-42a8-906c-457a3ec49621"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"25.88706613`", ",", "48.830987`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "124.1886514`"}], ",", 
     RowBox[{"-", "67.550334`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.91146997804877*^9, 3.9114700100676346`*^9}, 
   3.921167308756506*^9, 3.9213296050320406`*^9, 3.921330904984852*^9, 
   3.921330963461293*^9, 3.9236743800918427`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"1e816bb3-b0ef-4dba-b601-a84b6921b8f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"37.359026565`", ",", 
   RowBox[{"-", "95.8694927`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.91146997804877*^9, 3.9114700100676346`*^9}, 
   3.921167308756506*^9, 3.9213296050320406`*^9, 3.921330904984852*^9, 
   3.921330963461293*^9, 3.923674380102813*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"e82825f6-2851-4275-9e6f-d19936bf90ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"states", "=", 
  RowBox[{"DeleteDuplicates", "[", 
   RowBox[{"ssr", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sn", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FirstPosition", "[", 
        RowBox[{"states", ",", "#"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "&"}], ",", 
     RowBox[{"ssr", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "3"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sn", "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", "20"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.921330495584949*^9, 3.9213305292260933`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"063e3624-05e4-49fc-8812-4868cf48300f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TN\"\>", ",", "\<\"NC\"\>", ",", "\<\"VA\"\>", 
   ",", "\<\"SC\"\>", ",", "\<\"MS\"\>", ",", "\<\"LA\"\>", ",", "\<\"AR\"\>",
    ",", "\<\"KY\"\>", ",", "\<\"AL\"\>", ",", "\<\"GA\"\>", 
   ",", "\<\"FL\"\>", ",", "\<\"WV\"\>", ",", "\<\"MD\"\>", ",", "\<\"DC\"\>",
    ",", "\<\"MI\"\>", ",", "\<\"OH\"\>", ",", "\<\"IN\"\>", 
   ",", "\<\"IL\"\>", ",", "\<\"PA\"\>", ",", "\<\"NY\"\>", ",", "\<\"NJ\"\>",
    ",", "\<\"DE\"\>", ",", "\<\"ME\"\>", ",", "\<\"VT\"\>", 
   ",", "\<\"RI\"\>", ",", "\<\"MA\"\>", ",", "\<\"NH\"\>", ",", "\<\"CT\"\>",
    ",", "\<\"WI\"\>", ",", "\<\"MN\"\>", ",", "\<\"IA\"\>", 
   ",", "\<\"MO\"\>", ",", "\<\"ND\"\>", ",", "\<\"SD\"\>", ",", "\<\"MT\"\>",
    ",", "\<\"NE\"\>", ",", "\<\"WY\"\>", ",", "\<\"CO\"\>", 
   ",", "\<\"KS\"\>", ",", "\<\"OK\"\>", ",", "\<\"TX\"\>", ",", "\<\"NM\"\>",
    ",", "\<\"ID\"\>", ",", "\<\"AZ\"\>", ",", "\<\"OR\"\>", 
   ",", "\<\"UT\"\>", ",", "\<\"CA\"\>", ",", "\<\"NV\"\>", 
   ",", "\<\"WA\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.921330530101492*^9, 3.921330908616115*^9, 
  3.9213309656694574`*^9, 3.923674380157666*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"165a500c-1daa-43ac-a78f-e1edf719d331"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "3", ",", "2", ",", "2", 
   ",", "3", ",", "4", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.921330530101492*^9, 3.921330908616115*^9, 
  3.9213309656694574`*^9, 3.9236743801706476`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"5e2cad4d-8200-49ee-b0fd-7e962104cdb1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ssfin", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"mtr", "[", 
        RowBox[{"ss", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"sn", "[", 
         RowBox[{"[", "j", "]"}], "]"}], "}"}], ",", 
       RowBox[{"ssr", "[", 
        RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ssfin", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"1", ";;", "20"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.921167430088527*^9, 3.921167468611684*^9}, {
   3.9213295775016713`*^9, 3.9213295944849253`*^9}, 3.9213296738222*^9, {
   3.9213305471791506`*^9, 3.921330585994449*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"31193b36-d22c-4b6a-b04c-67d2d2489efb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"100", ",", "1", ",", "0.18980919192872517`", ",", 
     RowBox[{"-", "0.0022797036372169677`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"200", ",", "1", ",", "0.17663786686698224`", ",", 
     RowBox[{"-", "0.011630922016539591`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"301", ",", "1", ",", "0.17179013437930307`", ",", 
     RowBox[{"-", "0.002378919532717072`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"302", ",", "1", ",", "0.16706886602496626`", ",", 
     RowBox[{"-", "0.013989772395754718`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"401", ",", "2", ",", "0.2193031107953006`", ",", 
     RowBox[{"-", "0.0029014849025102984`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "402", ",", "3", ",", "0.22335256858407265`", ",", 
     "0.007102546325278625`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"500", ",", "2", ",", "0.22792980937039756`", ",", 
     RowBox[{"-", "0.0026727048821879595`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"601", ",", "2", ",", "0.20642589381458953`", ",", 
     RowBox[{"-", "0.0034638169508278693`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "602", ",", "3", ",", "0.2098171569529356`", ",", 
     "0.004298304552675436`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"700", ",", "4", ",", "0.20012752596251032`", ",", 
     RowBox[{"-", "0.02759262756491887`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"800", ",", "2", ",", "0.2071164415768017`", ",", 
     RowBox[{"-", "0.02006962880915475`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"900", ",", "2", ",", "0.21651127999631892`", ",", 
     RowBox[{"-", "0.021056414746903007`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1001", ",", "2", ",", "0.19892194281228368`", ",", 
     RowBox[{"-", "0.005012310027109779`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1002", ",", "2", ",", "0.19897328663355476`", ",", 
     RowBox[{"-", "0.013327312377917178`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1100", ",", "2", ",", "0.208545395881935`", ",", 
     RowBox[{"-", "0.011819078559883733`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1201", ",", "2", ",", "0.1787566646236678`", ",", 
     RowBox[{"-", "0.02878807266181138`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1202", ",", "2", ",", "0.17872980361499163`", ",", 
     RowBox[{"-", "0.023723530622324795`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1203", ",", "2", ",", "0.18900571826521395`", ",", 
     RowBox[{"-", "0.01940462469501314`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1204", ",", "2", ",", "0.17097043041762713`", ",", 
     RowBox[{"-", "0.030695636782514635`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1301", ",", "4", ",", "0.229657500170353`", ",", 
     RowBox[{"-", "0.028858346233359367`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9211673235150876`*^9, {3.921167442485335*^9, 3.921167469317176*^9}, 
   3.921329609443491*^9, 3.9213296749414024`*^9, {3.92133056465342*^9, 
   3.9213305880294356`*^9}, 3.9213309138716154`*^9, 3.9213309682095585`*^9, 
   3.923674380350808*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"20f6ef7d-8651-44f4-aeda-7b00d6d117f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"path", "<>", "\"\<Chetty_Data_proj.csv\>\""}], ",", 
    RowBox[{"ssfin", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9114698996241913`*^9, 3.9114699052153535`*^9}, {
   3.9114700255916576`*^9, 3.9114701528075247`*^9}, 3.9211673205599904`*^9, {
   3.9211674933630257`*^9, 3.9211675069228334`*^9}, {3.9211675745634904`*^9, 
   3.921167577986574*^9}, {3.921330664763457*^9, 3.921330680714259*^9}, {
   3.923674351448779*^9, 3.923674357417699*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"1375fbf5-55ac-42e1-b7fd-d75d8027fc7f"],

Cell[BoxData["\<\"c:/dropbox/mystuff/spatialur/data/Chetty_Data_proj.csv\"\>"]\
, "Output",
 CellChangeTimes->{{3.911470084788574*^9, 3.911470090781491*^9}, 
   3.911470129684292*^9, 3.921167511019605*^9, 3.921330683384593*^9, 
   3.921330928427378*^9, 3.9213309708122215`*^9, 3.9236743804016247`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"f4bdae98-782e-4904-9d7d-0062d8b7ec5e"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9213296929042015`*^9, 3.9213296994352365`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"c0639b6c-345f-4267-9f35-41c4cb627e3c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"ssfin", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.921331004755666*^9, 3.9213310882043433`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"e95d28d9-47a3-4653-82a6-6373b6722521"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.0055000000000000005`],
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVV3c8lf8Xvw1CkkQhhUjL14hKGkcipFAZKdVNlJCsQssVScrI3l17r8s1
rnHucO1x7ZVSqaiUioyS3/398zyv8/o8z2ec8znvIWt964ztcgKB0MV9/P/9
n9r4pxzDRiBskgl7l2eNYx/KutYl1APpicfkr84neO2lh7jGIhsIj+Yo0/ev
4rOPowd8rdlACj/nkZvxHLudr/ZIi7QCYY3fwFDddfSfYMt3RrUCyXpWO2Tj
A7jN9O1qU2wDQuBPn3UfbHEu5sGnnY7NQAioCVUgOmLbWfJbg2FurFlmIRHv
Atcm/C42JDYBUWz52OGjCSiZ5pfa/KgZiEd9F2WDIlDc+NrRtLIWoM/3inBC
InHpp73a8TtNQNh7itb0xB2Pqt36NO3BjZXdoywNn6F47uPwxOJmID1e9yZW
PQArNmhFeb+tB5miq0NJdxPx57U87aTReiBH5qn8ORGD08Tzb81VG4Go3H26
/XU47udN/HLhHRu03F1M8p1eYkvK0Vp72zYgDW/vFQhKRHdVTmRJYjvIPF0W
cPJKGtakiEX51bQD0aVUTNArEoNesJedcOYAeSnwEmUrGXN8L3CybTlACPV+
+jmIiIP+27zYUh1AUhMUiv3kjmXG/r0NFdw4ttw06K4HjFlb/pM/zQEty875
ff8FY4qq18FTGzqBsOGAJeNBED70oEztzu4EmZHy5wme4XBacpru/oI7HnXQ
4MH7c7jOVJA+Z9oBWh2emzhtwaDydtLQPL0NRqfM3TT1I8Ev3/qcB5EDMq8T
V601SwCL6yNL9LOdQFaeFb6pFgPXsiRtk4o5QN86MkQTIUGYv1jgWU8aiEeN
dDxurcHNmhvsN2VWwtzpLyKpxyvw2n8ziykNFSBz4t6mS0doWDhBumWUWAYx
T+/42tpR8Hp7k6/GtVLguJL1nIglWPQ9R8ctnQqeUkZtMXxlGPWxOlVCkApz
VsnOw4QqVCR4K33nxoSC6SAXt0p8FnxLerlUPuyYd+q1E6zErlMX5sv3FkPW
Lt0sYe64Kx5ZbMikgIZbQYfg/TJ0s+9c/+J8GehsybXbJUHHic4mncekEij6
E5q+noeBnE/56S3FFJiamGS/P1GLOd311ff8c4BzJrafsrEKB7qep09GpwHR
qtbidWYtiqsoiF0xzQcZD7WpvmBE2R975XeN5UFoyUzoFVsqvlGaOvlGtBhi
BmU/nOMvxTQN5SdEwVQgRtjdZO2nYLn8M+tH38lA+DNjfIdBRdfV8by/LmbB
XJSIpaJUGX6+pbQrJzYZtOSEbl7qrMSD4wZ73gUVALnIx+yuJQVr8kZus75y
16/T581uz8cHIiHj6VWZwPeH7/ezK8VYW7lbKOtdNhSpbiE3uGdgdegQIcir
CISlO8/m6GfhLssm9tmbhaCS/Y4tdzcZl3xUKmo0uf19JWvTUSVn4LVQsIkp
qAN6mqiNyVgQFASdNPPirQf6/rPknpUvgP/dUD+zpR4IlrR6vl5v0AxV9JOb
ZQJJlp1rquwJhFW/1ebF64DAN634oV4brmYeUqb2UiHLqdojTrUIja2/ProR
SgWSQMUe1+Ac9JF445FDp8B4SJXLZEMR1sxsL5uzqwQZvdgPstVx2MwiHmW5
lAPp44VPQyLRSDeIfWPZVgWEhs2tQ6Q4VD3QdeWJIw04VteYaYRcfGgbsDlX
twpIs4xoYkYqjq3hafylWwnk10M0fu8MHBNbVqLcTQXnPcx7Om0p2Pa55MH3
yyUw1WZdGb8vDQUa1q292EQHwqurBlIzxvh077LI5lVMIIxWKwTMqoH+88ni
vN8IZOGBjSVS8Xiu3SKlI5UOpEn/XadOBmPVuhIl3iQG0HMHfYzPJiBnkX09
ObgaiPIk6ccXXmBSEHlIcU8tEAwe3+G5/QAfmq560sKkA+cNI+dffho+v14c
GaTIhFABBV2ZzEz8PDuQfHdvLRDT0mWeNaeif5C9R6w7E7S8T4+KD4bjmMzK
rz6tTKDni9UnvnyCe9/zCDReY8HoSXNCzQMy0txiXNfRuPHC3arR2Be46+k1
BdutbODcDtneuSYF3wu3JszergOZzFzRiw7xWEC4+C7wNwtMPnrQXAUzUN5r
5NP41WaoKyPyXHdh4enysx+cNrWCjdFhg4gHLDwQcXLb2u/N8DqTcuKMPBvP
OMiEthR3QJ5XhdEWagPq7HraanS5Az6veasdksHGq9Lraj3OtoKU9r+L59n1
WMckNnnuaQfS2RVqNmVMtO+97ud4txX01xE6m/oZWPrKr0+lohUS9t/WFvOj
o/XONbu1Q1vAU8y4iy5TjaRV3Wa1nxtBZiNpTb5ADS56b6MH1zUD3dXNdXKW
jv91K6j9UOHyx4DvTIEWomWG8KEtja1Q1GlULqOWjudOfHm0J6AFyKaHj9jd
yEB7zVk7y8AWGOVb2042KUDJJ72eqfQ2IJo62u0JLcDgKmHVlZWNQJ5vT1Sz
TMZiNCh+9qMJinavjjV6nYvLQiIKlIy4/LHdcEtvUg52TSgtCa9pBHHlU5xC
/zK0vbg44iPZAHN13wZtT1Mx+s2TdROvGuCcfNYHll4lWlouVdx/wJ1vInZX
MqMc7986ub7hbgsIs+Nzx7rL0Uxn5aDct2aouCNIu6RARakZk+UPbJth/Phb
t0uCFDRSPhQl8l8ryCw7pKlsWIKu2qveT/2pB7ujxSo/ueMFNsQHxO1NoJKU
K7vyRSmK2MsxQisboJG3L7xIpAj3PX1Qsjecu39G0Sb1pWK8+F+Mt8MdLj4U
tvrdpOdgx2JnvziHDeKpBWKnLnO/371hRFyhAYps5Y9qvczCG3b33S3SG4A+
XSxlXpmGzvprNu12qoei1wXisTfT8eYItZdzlQkaluOj0T+KcPl8e4J7DQuK
2jWHOO8K0Onc1dbG3DpQYS/ufX6vBK1etA+1/WWDxvrz1Na+UhSLlmB8LGQB
gXroGC27BN3O1VqYNrJhh6f5hKpZNd55XXc6Y5Y734jD+aP6tfjoarW1eiAb
xgfmjy/c5fLR25S7BlgPjSpl3qrPaHihT0LS+Uo9EGckjfuelGOhjcSjY5F1
oK+ybqnZqBwTYzXGj1K5/fAsbGeNfiWeGuvLc06igYzcd/EpUSoyf0qbFi2r
Bk/TRf7LOUUoN72oPtJfCRrEuRCf2iIM89H7ojdSC8Irq2RvGubhidzygIuz
dBA2zL3ZJlSI5U8k1KraEEapImf2HqSgWJtMTVxsDdDDOzdOSlKRJ36UckKO
AeLV9ZffL1ajpXS53hnpWhAfG5T6D6pxqahYtcSPi1ep6qZylZW4yku6v2MN
E4hmWwdXNZZi92pS93k7Jox/Otx0xKUCf78rrfZNaQLSUslkbXgAWIoov26z
5eqt1q/21R9fQOzf2yrioQ1AEu54ZFZ3GyKHnH77qHHAJCiUw382HbK3zh86
ydUDo56ClTs+FMKK8x5PDi5xgMR79aGcSyrEVohZpp/ngPBjYX8b/1zIG21/
SH9Jg6/S5v5uiXXwNt7icGZ1BcjrUGev8LNgkDksy6/OAOdTgy95trGhKqjl
oPl2Fgg72KltKiuHC45WFy8wufUQ+8w4v48GG1DD2SiGCY0Dw7XGZjQQ2cqc
Zv3m/v/FanGjfi2EOwnHXLBkQdbvTWj6sBba+661JLVx8VXw7fwpFoLTTj/9
S19qQT48S+2AEB1O7fOxKlBlQNYU8/zqPRVgPX+D3ONNB3oO0dHPrAo2MQ7v
sLDmxp5N6e/jGJAmEDl3/gQDdKbbTRd2seDI9IbpaEcWEB/MCx3czIS43POB
LkpMcOyXoZ0JYMDnB0H1HlvrgFhrtGyYlgvvrj9WsdjOBrL6kPVQfyZotrYn
9KVy+YVEr6iSz4Gm5Mo9sd0sCN02Uydgmg5ByXbVhifZQLw0PVNOJMPTCLn0
tXFcvN+89J9WRxrcMbpnzVzOxW8mS0WZFgU7PbvkrbS4+jxP6VvZnWjgAfeN
ecUsoLs4hgQcfw6DsVs4r64yQCthxYZdtc9AyW/jw7h+blz+5MjrxGgIn8lf
umXO5fNIcd93rmQ4XEdetuX/663YWutcHgTz4SvjVhxDINjGp+k6+cJmn/OM
PlE2OF95I4jpJdD8bJ5al8EC54CPy1spxTBxaO2XL9510LjLV/64SBlsLfnq
e52HBeNiURKXL5XCh4O6evo5CEV7H9gc1KDC2hzvdCtJBlSktc3F21JB00z7
+NoOOng2SfCvLaVAT7wA8ddNOsxRpEibLItgh/sZx5k8BhAjicObSvLhi/Em
NX9JJhQN5vicaaBARx/ZsrKCDlM60swq9WwYXFnffe8aAwgWniIXmClgQOb3
b+2oARkfmT2zhRng5D2+P+1LDTgfIO43qswHy/dHUy2nEEL1mfvjB5OB/9Xm
usuN3P48QHXvSQ4D6Rvhe+WHaEB8WjB84XQ0zNr8TRtX5s5X0/Ql+HoiTNUu
5nYnVEPMro6ZsU8l8DvOOv/khUYY/7zlz7KVJfBI44QwfzNXX5l4Sdo4UCHu
lG2xmQDXjwUfGrnGUwY/+zLGjMcbQaU98WrIQhYsfpaf1OZpBNIHSrnZ8QI4
cWfP6d1fm4DurFQwu4oC9+r+FB8a4PqfUcGBrJ5CKNta9bz8cT04z17+tycl
HYRfWO2umGgALdpx9/HuDGi7MnsgT42r514GER/xF4C5sKfFRdN64IOuK4E3
KcATt+Kp5ts2yLIpOr6niwpvv2oMvrnA9Q9Lozuf8pVAGr//zQFNrh9T4EQt
cuuzy0m4+E9JE5xzLXlud5gKunN4cbK+GTjG1u/f36iE4Ve2sf0ruf5Qb8Xy
yZuh8CZ1/fOfr7h8u7EnWPdaJgRNmOX90WgBYkV5k4dnHiSadpz/y9cChFM/
no63ZcLHTyvzrY9y+X3NqmHPD7EwHzkSEBLYDMLWbcqF4qlgJ2kffXCsEei3
TjmKdb0Euw39PwTvN4HWkzzFNa1pMCM7tnY8sQEIr39oqfiGwRJ7dQzlYAOM
Hrj3oluEDKpaGYtjs1x/F3j4cOzhDHi25KZXZ94GJixXEVtjMpw8EaC1U6ED
CFu00jfnFcFIYqSf8JE2KIrPcIpRL4Cp566l1DCunkna8n11cB5sZPREJf9s
B7ITa5fRoxSwE+cdytbjQN2iT8xOFh0Wg76caRPsBD7rd4t/tRFO8MfGrw7k
gMqjnQvyAjXwmL+nSvRdK6hcitXQM0NgLvOVenGlA2LE5BvkP1UDtTluIXCh
FYQzcH50bxWYm9zXCP/XCqEOClbxayog36H1Er8O179R3Rfo/ixIkbsc8Daw
E6aNp47XzdXBjYFZB97QTtCR5L2UqcuA+xUl61s3dYHMnZtRj5YxQGhVvrat
HAfmHGx197wvAy3d1PB3XzlA7PzYccClEkyY4bz2jR0wd598lrS7ErwCGvff
sewEjuybgypC5YAGPsUvern8YX6sPrqhFCif1ZxYXD4Zpdz9rexVAtFUUUKG
chcIl+x7ttajGl4yhqnarC4YgJ6T0d8rIO77+1iJ+C4YvWK8e1chFXqdnvSy
TnUBWYh2q9u6AlQ123UH2jrBxCfg8yqhUsjy2id96VYneGZ5n/a5QQF/Ion3
2zDXD/f2D7W9zoVrA9s900y5+3NfbFP8ngf/AksX1n3qhNGAwZ5t/ingdqtK
1sW2FxodlX+EKDeC7Mrt2VEX+iBArEyQJcLVZUh1yRbvhbm5Bwmidq3ACZat
vB3fA1muyltzR9hguNFq+otmF9hQaXxGtDrYdbH+dvCmbrhPKijbtrYeup85
iAUv74ZXiXs09vPWgZlw3ZqH3j0wymlckqcjeHxW6eGU9YLd9bDUnaO1kBY3
q3fpADcOv6P4Y6oWYp1X2PTb90CMlmCN0xEGUPXoD6s29sCUwznx9ctYYEUy
uTm/rxsa0yUEupcYkL02TSnuVDfw/TjZ8lifDn7Kcdo0w24gr/u9q120Bnxm
HiSRS7og5mRKPqOQDpcv0Up0Cgthzqt6/5F5Fjy4dWKwyKAMbN4JTKfy18PK
1q81Tq8pQLJjZW3l+sRkTvSJKIVS0GJnvNl/lKvL5uNkyspy4Kufy/01wUx4
rTA6/CcwHRJCLhZQXZnwNPjIeXvvcKB3GZ/x5fJyebrbsh3SfnAo5DZRYzMd
LtgfO1WXEQkDb13sHV/WwrlhmTR5KzLMfWU8pKTVws+avzPfqyLA3ac5ecKS
CTWK/GXx8WTgk7p047oEA2LLSzJMmMnQcyxkSuYmC34ZfGuqW4iG6VG1pihz
NgQ2bWvdP5QOoU5Jmnv1aoF8YNy3gTcFxj/0FA+YVMOJt4O6xgJkGOcKyLwN
NBisr5Jg9mRw8UIm15xIA1fWYNLQqjSo+PPqzaWzpfC6psvR6U4mCH9pcfjk
XQ7ie27vsLuRDDGcQvHGQ+UQ/S55lXddPpAnmNPnNUpgbuv5adqPXBD/qC4l
spsK8pSi1fohGRCzXPLdhHAxHFzO5v/6oxLo+0IJw7dr4e2tvJ0JN8tB6426
ruNxru/0os+KKFWCe4af4olmLn5UsZ1bFMtg1FtTc9aRAYfWlj7yESqBnueR
l2e5+f26xaaguDYXBG9YvMu+QQfdkJlGZXYhV695nwy7yq0/YV+OkQwFRtPd
HHYJVILOw2irH4xSkDnXUZdeRYONP0/yLhgXgcbBbzHfWsphQvSWVuEIDUI9
NbKFz6fDx+Xt36G9Epwl9r9+nkkGrbDEu30/yiH0WIVoo0cBUJlXxilqlUC6
62Oy3isb3jRZnoOJAhBWSXZ2zSuAM3s0Ph1+TgEO49DJpxsKobtm5CCNnwIV
+ZOyf/9RQEAw8731bDHwtfkb7hejgq+ecLoTkwrk/o1/wu4VQdNVHZoAqwLm
/A0UCc0VYJY67J1uUQlTGQlO9nU06JdMn69bVwWjPA5+HdRiINJ6tsYn0kBr
ybQ1n6sv0s6HxN1YWwYmTlSDlL1lQKhXXXhyLA+0TrWKVnn5guVOXcP+fSVA
6hCS3MfnB/VDk/s7N5eAjL9okEFkDMjH3ny8bDEPSHuu9jXZkCHoSMSR7CUK
yHwV/rP8bgYUbHE4EJZGhdBnVT5nIRMCZg5+WP6cm19J0c0aiUngHbbq69rr
heDcu2+4OjsDrv8IvvEkJYuL14pbw+ZDUcp9iLK4Jx8IYy/uaS1/gLzVb8aD
LqXCqPaP5YoYjpuO5Zf9ysoBesvOPzZrklBIq2U8r6oASN8mJ8IXo3HG7f6a
W8trgKBre2x64j7oO7Ysj4BK0Np2vPffmycoGx4hZDxVCYScgVGb3xZov7Ei
j1+vCkjvnhY/HfFB4/m+cWZpOYzGxx36aRINd+XuaX27Xw6kXA/e2snHwKA7
1T08RAMS2rmO6j6GwynqDbEbuXmU/G3JJFpjYIkPf4YMN38ru92MJEloa15x
RVWbClorI+tOH47EymfmAwsDFNBKunA241UUSp4v9JBLcQCVY9d9F+41QZfB
4bOuwelwf5AmGS5QDw9niorXSBZBqIGAl0FVA8wqpJe904iDamGFYMGsRvh+
NsW1e10WjMLQxTy3NHik4laprpsMZAt7A1fzFFhmbxlndCsVpgavKv6BdCht
inH9se8lmFzbWXzMLxtIxg7DZTypwGEhWbUnB3QGpqZ9k1NAeOmc+DnDQtA1
e3o8UDETOLyTlOojOfCDvPBdgacQS53zeDbUsMGhUC006k8xhq7wfVEYVAd7
Ss6cjtmdhRVLv84jfx0IPNU/Kf01E50f2J5RKGRDqfC7b2YFyahRKG64QbYR
1PVEeJ86p6BMOn3/s+/1EPw43eNYRgYWnV4jbpPUBEocR+by40V4X17xe1tL
I7jUjg02y2ehTtjHFc9eNsDM35F7X80qMW+4QVWKlwUfVVIP6JnT8OS+L7Lv
B7h43fM9teJiOaYlHXIW1q+DT4npN5RiSnEq8qH29w4WaOyyOjfAV43V6cTk
Podm+DPZkWITVoWlahnhLwYboY2trZlrVIkavkkZ74SbwaZkgK4dS8eKhgvy
pzKbwPSaRK/wExoqVg9tYT3h6s4QI4WOsVLscdJT3NDFhjqqTFyuYDn6dVEq
KxUaocfx0JlW7TLkc2taCjFugi95XsOC/U+RPpfi4U9AqNq4aDVq9gJJVrWG
xFau7p66fztCPgDFBSZ5dO9VQUPMpnvkW6F4TrpDtoSLhyOPcqLS7HwwTS7i
nscMA4TTpo9Msl6g3TYziedWTNC7EDwY+KsQrdQXxXVvsEAzgP0pJiIHPRXk
RzvdmWAk9Nq1h0bG8aDscGcJJpz5I3jX7dND+Ju42yoa6uHocPbm/X8isLEq
++Ty7U3wT7MsLfqEC/69dP3FZXFufrQZHy3PPkfTl7TH2rYN0BsYEf5fcQDK
iNO9+xTY4DWosrDrfixGrO55vu0tCxL6CZ4kEhkjvmnWTp5nw3WRUK2I4wlI
KJVbqE6oB0u5Ife1QjYQYTDzbPgBC1QSZFVNWoJAcG26QncKC/S6RQ4+qkhB
4UNPl8Phcojo1rEU3pyGO3Lur9x5tAQci2fkTK9nY0BigLZhfDnULBjMXOTe
R/1fazYLV3P5rSShxqM0EkdbBiLWuFVAW5Ps6p6hBCTP7NPbEFgNQXfWGZTz
v0STGF7rC7cQXgsI7NytlYR8Fef3ng6igeGeoB8E/wyssAwv0lergZquCYOc
0jRUf88+s0eJDt5Z6YPmhbk4t3hk3nUJYb3GzVvBKdmok/znurcFA6I/lOus
lbsDnvtodhcPMGBNUIrDvkfWaGIXwSn3q4X6+O2VviNXkE8/NdFnsBKaNS1w
k68bxJTtmKgJq4bqL5sPLFN4DuSmHpfbojQoD7IgbDcMh6L16mmU6SpoNbGr
2mr8AOi3n8ulX+een9HW458RBRWWK38KKpXD8Nn/5lVlEsFzMv7oUdsSsFw7
kCjEiAHyWFZX0LtCgB0NNUd/+QGfXIXathIKfKxYV2TeGAABim/XnntXCpdP
YyrSynF8S1KC7BWEoX6v/TzNRRiap37OPpcBP/bEmBVaUHDUjLA+TbkWPlF+
rtm2WIBEWXUKc7wG6gavct6JFeEUPz/tOn8VOHhXuCwTqsTQIdFfG7j+b6W7
QcL1jTVYdGJ3Ulwshesb0u1NeqvR7s9/+TYNZXBk2ZlO451U1D+2TeLKNhp8
0Zl8M1kShSpz07veTJeC1L3CFau2R6L+n0KXVF8K/NO95aonkYwyoRUJps55
cLI6YPNGiEbiKEEK9Avh5LBK8VwyGQc+e5anKBRBjO3lPWVWnhg67e5e0lMG
Gy/fvM3HfoQc4vtVYZGlILr2TYt68hMM9U789Z94AYguV3O1kzdD52dqvYZq
ubCNV54hK+UHMvcdg9KEC0G2IGKJLWKNKoJnFVVdi+HjceWNv0bKUaVCQcoZ
8sGFk2/dpl6KcxmZYTNqxXDg97qgqmwq0iOH95c7lwAxeEk0MaMYSYYChZRL
5bAuuneVe0k26pcZqslydcT01jJBSdciJDsFs97LF8PqgZNvVksjkr78lnfb
T4b6HdKwj0ZDgtOxtaNvkkGcVzovvbAcCdGTAWWXb8C6/UMrSb41SLdnJxTu
jwDClfbL3h9qkeT4sU7G5A6YaNv73Vcrx9A/XXZGcslgnXtDUyG3iPv/878S
YRlwJMjh9qn8XNSKzd1VfCIDmPz/DakdyUDO1xODIV/SoWfv5srjSlx+GOUz
DqMkw6mcf6/lLEpRmBB5pOZwCih22Zo+nixBzuG/vJI7suB98tbUTSLFOEps
/rmwlAOivjq84u7p6OzO7zX9vAB0Dt7wL/PIQcL2D2UXb+WDVMqPidODDCQ+
clLS4fJaVH+yeYw0C51f7zt7ipEJQndtNz9zY6Czg/82N7s86L7h8TAugo58
2x/cse8qgcN/9sno99dikfPIowPI1RFh9I43lxCFnxryvCdngesOk54DGWlI
UCX+xzC3hyip0zU0ahYSRicU9603wQcjHUnyAvlIcDUUOazxEHJk501jzNOR
nuOyUm78BUik3nPp701CwpjFnpLHz8B2Mqh55lkmEl43LpwLSgCKgbiPjkk2
hqZYcV6dSYH1bGvbV1nc+ZbV+n2QjoJ7Izpz+YuxXLyiTWdkpEFl0n6ml30c
kjkPfYxVs0E+WiXMPyMZtUg6dzXDUuA2h5mxYigGieL2e5un40C+heaxWt4c
nHP73Gpep4OMhWvVutYnSOKp31halg4rDr9+e8UhAE32ZKbx8pLhE1tspbqg
MxDs3VLoTxMh/tjNCum3EUja9uRQvdAdeEBewzq+IQrpQj+/k7RCwKFtJzE+
KAAJnAJSTMp+7NUsMTVc4OJPRKlo+vJQ4N+hYskjZI/k8/3XnM+HQdmXwLPH
LK4D4VOF9LH97ljUycsrJfAESP+teL7DKBlUrlI41xLCgLTm3WRZWiLM51hq
qTqHAjl6SG/L3XS4qjh5/ftrMhBGvl7W9o6A2yJ+5oKy/qCVqP9pJDgHsu78
cSxNiQLhr+TnAjdywCrj9wbpuSwgh3K2SfyLg4u8fi2HDTOALtJxcYoWAg90
clXbtVOBUKqv6OxgiGgmcdfpNBlIy/QG1S75olGcl+5LrzAg3Okz1hlzQNHZ
yKYfx2KARFqzVvCFB6Sv37xr7FcyaAls5JEQScEP0enJQldfQGj9wcDfgqn4
qpr2XkjNF+jPF2BKPhHH5B6up/FEw+jd2orjreHYqGttRj0ZinQp+10E4Sg8
OOX05HjgeSTxxTqqVUbgV8Mo//1hNkgmKFrEriEje0tMCKM1G0kKzt1RRcG4
QaBFX02NjORhVVH5tS+wLqXmvYlYHXp+MnhoFF2GkbbGId+jmGhHYDuozxQj
e+KX3m8nNhIGlMy7KEVoevn6r5qdDTiwcdOKtfoleFgv8NfnTDpOdX0f/lRW
ife6J+QdRxE9t5bO8BlQ8CdZuyB9PR2J6uV3ngqn49jPzxmHvtLQ88DsKoZh
CVZFe4vscSxDma7Iw6FnilBpVnel5KYqDO2M2mzmlYXTJ26WDxlWIOnbzYdj
Mdw+fvSshEe+DDnLBnXK3FNwsHW3gPHKEiTWFWerRSXiLnHG1GmhIhR+PMV3
PD4Fb+8s0Xfg7mPU/63Fm48ZqG+2uld2PwVVEmRE71/JQ4H7czH7E6hItJhS
rjbLxQsqWQcejRaj1rBS9e7op5B+K//k9fASJAT7b5Csd4IT64SDfqZTUGaA
X/q3XhRsM1Re0XSmGAmGUUKt9x0xn9McckyMu56QXiz1byjutotulmovRZL0
p7QH/SScPc2r60ktQ2Js+B0lehRGF+QR1m14gXy6mpFj35gof/P5XdNvgah1
M7Ty8SId9ZHnS7tPLJ4zktodmsxAdLqv7BeQgBodMZdTLyCOxMi7Scyk4Nx6
gSdHomrQywI4dIs0rH4ltTgUz0DpqVOFf8SS0P1g3IRuAgvvDf3Zzl6TjRpu
vgnWonQ0W+fhEVWYjZ7GCRPG5jV4XLfp35hJBY6efKy3LqgcP527G6OqX40D
x7OO3FSpxCmle+naRyoxQPycaOz2alwrG1qYXFWLnmmXpOgkRBel+LVrSAXo
9zD+WNtxFp7UmX581J+7nkrml+VKLLTRJt/wfJmLW89f99YeZKPIhvRy/wYy
7vJ9NB0z1oizK3yqtCvi8DPlk02SPRvrbx3W7Sc+wHNK4QEPBWrRZvj28K8h
Lt48M9eTO8XEA4Kn/wTIe4OM4IvrGyfoqGsoGtFmHA98MgZbJL8hSjIXY13Y
j0HmUvCbrQLVyKHq/iTfioK5wTJJnYhKjIkdCzMjFyPneIV2kjANy6drwtiX
8rFo5aVU7/FKDJwJ6vxMKEC61huaclUN/ky+ej/ZoBAd1zSlPLvAwP4M9bme
jyX4qq5B0nYHA5ue3rpDpBaj6OWAwUhRFrZQcg5UR1JRRlHyr4pgGUrzDSRe
EC/GHd7L4kg+VLxIM8qpEylBDeKY4E1mKW5ivx9d4t5LOm/H27NFVNwdaEby
4N5nrUFbm/nNOXhy3ZnAanoBVrzRK094Xoxvqi0O3VFPQ5WQG6zfvgXIIsO/
n6ppKPyio/imIwXDjhQ09ahmo7NVlM9SaBGieptux5Yc1EqKNX92KQ9//pap
Dv+XifSua38/b6lElvN+T6ZDCoZmG/eCTznqPgzwSvoSjirvbi29qKrEQyVR
83zzD3GOKLnNeKoC1d5+W8wZiMMB3xSdo8wqFCQwRR+KRiHn29ON3wNLMffo
ZkUN9jMMpYjo8gqXopi+ptjm5EtAKOBJS5CmYF2/z9lFUQ+IcchtKWkuw+NX
mnr3bgqD0AtLxHevqegac/mcoGIUOI/KjFkKUJBH1bA+n5qMpBMihILaLKRI
tx5xDMpGQvNLJxof9xwJHqvkojNw9NCUrKpuDioH+3REOoehyoEFnlJCLpbb
bHO+qZWFoe8X9ZyektE6QHNIaC8ZVQp/8dyXTcOSrT6WLl+jkPT0jF3fVzIu
m1/SejVCQuLNmJZPDzNR9smf9uicR5ilm6hTeppbF+21VoePpQJx4XJ8uUsu
FlCCm/vTQiB079iQu14eOm9u+7ElvQ4J1F+TVq+boUV6bv6QRyOKLjTUH45t
gblTT0dP6DQg8eKt2vwfjUD0Ofr6Qkgdhh7q2KIX1gBe9moSAs512JN4jxlR
yoBI82CBre4szFIeunTtK8K7qLeZjPE6tDM8nXJ3pBqoiYNMWikDI3anJRzn
ZcJFhVyHjxdrsbSiwMNDig3tv0/dNh3i4ooEeURhbwMcjOp0iOLqGxnGLnkf
lTo4b21dbl/NQp2FH9IuLnUg/XZrkJ9qPXLUgp4pedWDqj7z7wy9GXVGc4Ja
LepAOMCH71JlA/oFRn483VYHSucoPc9HGvFcbsfV264N4DE3rHphXTOO/jgy
F3qmHjYZOz83kWhHKRniTtXYNgiMrF3FV9OKfGlt3x3prbCp7bFaXEALtl6k
uX091gLE/wKuXGO0oMlxlhbLsBF85Rq1AoVqMeDtavn6jwhW8kkTlxyZKM7Z
br2xjgoP829DixgDx3Malcy/0YA1GvtXXL4a9Ytar0s00+BMrm71Hmc6jm79
GybhFYEfFBTexkczcfTarf0/loVh8vfOmYab1UhsW9iWopOMhqWpc8vkqpDg
T82h3/LHlbTN1Yd5mUg/t8H5Nq8/xJ16Taa2s5C4plRBwOslnmXQXyYJslHm
3tGVNbxZ+Mxmd5ugQTvSN/Be3LEzG7d2vW35wNOMMR0821/ZF2HDaMaL9sxW
bLyqXjt1i8tjv1Isy2hsJJWZ5+yqSQVNFxHdaB8WkgT9JB/vfQnjmkoHlua5
fGwdGHflpQmsVn7Nsg5uQwJTVyzXNwzZYvyyYocbUMsoaCLd4xm8rVp39jaz
EUljLhOcz2F4fM1/wyop7ej8pYgh21sLQkPMqgGLNoyZrX+aaVgDzjwGop8j
ONhjplamRWBCn2Xj2F3ZThRWTj9F4mfB2pYVH17ycTDhm/Hpw2F1EDX85EaX
egdXr6J5S2AM8PIoZxANm7l++Cf/j+hcSKv+VtRX0YDCJvdGazXSoGmXg7GH
YiuS5GXSqkrSoOGd4FMH1RakX1YWji1LhieEq8uKDrVglsBDXrPgYgi0l3fD
fS2o0rGr8rBNKSzkR35IWNGCFXfF799nVoB1jhVV6GYzang9PjtSjyDwQfKK
ZE4rvtLMTu8KZcHK2CNG76Ubufj1UunffjqoPfmqNcxbh2SV+oPTZ4ogduP0
iPbbBtTfG+8R0l4ESbwhS+6NTdhIvAYbpqqgct29i4lWDcgHM1OnTpSD6Yjc
QsOTXpRv+erEV0UHizeOkb9au1D9kFHQ9RUseBCxcP2lcQ9O11v5DEkwQX+C
DUet+3Cc2rJun0Q1fDzf43Onpx9lojb6OxO4fthmm2CzfR/OvfwiIpPNhDtW
73j2h/QjyeD50O1oJtye+ycuGtOH08LqXz1WskFJ/6/fmSN9aHK16N7rVTkw
18pPODTfgwTWwsLl8uswHZm6p/pFL2r1nBqw3p0IO77xqo9f7UMZ5qNog+Qy
mBrdRvE+24cxZqv12EPF0OthksFj1o/CpX+rVjpnQVTTnM9SLQc9bf6d1u2j
wpS1S7NRYhdO/fp5+b4ZDQ61xFDz3HqxiF9bboG3ApzdeAKFonpQPPIn9B6m
AqV4Y3xIZT/uyCzXHtcvhX3262UinfqRaMo/6B5RCPr3tHs9bDuR8DjPf13c
bfheJqUvM9SNwqprWNsfFcDrAiPGgdluJEp/rpcSS4bBh0Nbc4R6UCvILXXg
QCY+0+m//JW/C4UDT7oYqnL12s+YdvPQPq6/GmcRyZfh/FpJDb3UHiSGX7DV
D4jCqlD1J8cJHJyaMvao4uIHc3VAaKg6B6U2nJ5SLm8CLQdR/tXlnajoZF0q
SmyBjhsLFf26Xfgqospq5lMrJOqrTXYs56DpvlVLuskt8Ip1Zv3WVxyUUT8Z
+/ZfG2hZ8MaZifSi6AqxxqTZFnh+zTVR5UsPDmxnbPS63QQ17/UVvDq7MU1h
W2BvXyNs6KxK9Yjj1ifjxaoQnwb4NlLkYCrRh4LJqCK12AhxYv9ORn7oQkIF
PaM3rRlSy/q3yX/qRE/b4aXHI40Q9OcURdaG248/80Wm5eohXdBwPhI5qLXg
6K35ox5KvicnnjLtwQg32SblQDbs8h2VC9rQja06PkJ2Ig3Q9NP1RPWlLnw+
8/ZljzYbosw17T986sayPdcKQpQ5MGFyRE3dphu/8agVuBtzoGXe/LcbN58r
+T4534roAMUzrZ2Fg9z6aAa2GZS3wf8AJQUccA==
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.37234270743048936`, 
   0.3493401195410702}, {-0.19447624148326642`, 0.25484959613467495`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.921331024466588*^9, 3.9213310885568085`*^9, 
  3.923674380598547*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"4eccbf76-dcb0-465e-8013-4b7afefcf67c"]
}, Open  ]]
},
WindowSize->{1525.2, 788.4},
WindowMargins->{{Automatic, -8.399999999999864}, {
  Automatic, 270.59999999999997`}},
FrontEndVersion->"13.0 for Microsoft Windows (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"4161e52d-0947-4377-a471-61ead46f85a5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 289, 6, 36, "Input",ExpressionUUID->"0a252a8b-ffd8-4b00-8b98-a3fad51bca0e"],
Cell[872, 30, 190, 2, 41, "Output",ExpressionUUID->"638f6ecf-ae47-422f-8934-7f495dece0dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1099, 37, 2551, 74, 161, "Input",ExpressionUUID->"909c844e-a469-42a8-906c-457a3ec49621"],
Cell[3653, 113, 521, 12, 41, "Output",ExpressionUUID->"1e816bb3-b0ef-4dba-b601-a84b6921b8f5"],
Cell[4177, 127, 380, 7, 41, "Output",ExpressionUUID->"e82825f6-2851-4275-9e6f-d19936bf90ed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4594, 139, 811, 23, 87, "Input",ExpressionUUID->"063e3624-05e4-49fc-8812-4868cf48300f"],
Cell[5408, 164, 1232, 19, 67, "Output",ExpressionUUID->"165a500c-1daa-43ac-a78f-e1edf719d331"],
Cell[6643, 185, 458, 8, 41, "Output",ExpressionUUID->"5e2cad4d-8200-49ee-b0fd-7e962104cdb1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7138, 198, 1003, 28, 62, "Input",ExpressionUUID->"31193b36-d22c-4b6a-b04c-67d2d2489efb"],
Cell[8144, 228, 3200, 70, 141, "Output",ExpressionUUID->"20f6ef7d-8651-44f4-aeda-7b00d6d117f4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11381, 303, 773, 16, 62, "Input",ExpressionUUID->"1375fbf5-55ac-42e1-b7fd-d75d8027fc7f"],
Cell[12157, 321, 380, 5, 41, "Output",ExpressionUUID->"f4bdae98-782e-4904-9d7d-0062d8b7ec5e"]
}, Open  ]],
Cell[12552, 329, 175, 2, 36, "Input",ExpressionUUID->"c0639b6c-345f-4267-9f35-41c4cb627e3c"],
Cell[CellGroupData[{
Cell[12752, 335, 343, 8, 36, "Input",ExpressionUUID->"e95d28d9-47a3-4653-82a6-6373b6722521"],
Cell[13098, 345, 16364, 284, 333, "Output",ExpressionUUID->"4eccbf76-dcb0-465e-8013-4b7afefcf67c"]
}, Open  ]]
}
]
*)

