% Chetty Data extended version of Table 1
% This program formats the table into a Latex file for the paper

clear all;

% -- File Directories   
outdir = 'out/';
matdir = 'mat/';
% Read in the results from Chetty_Table_1_ComputeResults.m
load([matdir 'Table_1_Results.mat']);

save([matdir 'Table_1_Results.mat'],'Table_1_Results');
% Break out the results Pieces as in that program
% -- Table 1
Results_OLS_CSCPC = Table_1_Results.OLS_CSCPC;
Results_OLS_Cluster = Table_1_Results.OLS_Cluster;
Results_FE_Cluster = Table_1_Results.FE_Cluster;
Results_FGLS_CSCPC = Table_1_Results.FGLS_CSCPC;
Results_OLS_R2 = Table_1_Results.OLS_R2;
Results_FE_R2 = Table_1_Results.FE_R2;
Results_FGLS_R2 = Table_1_Results.FGLS_R2;
Results_OLS_SP_I1_res = Table_1_Results.OLS_SP_I1_res;
Results_OLS_SP_I0_res = Table_1_Results.OLS_SP_I0_res;
Results_FGLS_SP_I1_res = Table_1_Results.FGLS_SP_I1_res;
Results_FGLS_SP_I0_res = Table_1_Results.FGLS_SP_I0_res;
Results_SP_I1 = Table_1_Results.SP_I1;
Results_SP_I0 = Table_1_Results.SP_I0;
Results_hl_ci = Table_1_Results.hl_ci;
VarNames = Table_1_Results.VarNames;
VarDesc = Table_1_Results.VarDesc;

% Number of Variables
nvar = size(Results_OLS_CSCPC,1);

% -- Table 1 -- 
nc = 9; % Number of columns
% Set up the table
tab_file = fopen([outdir 'Table_1.tex'],'w');
fprintf(tab_file,'\\begin{tabular}{ ');
fprintf(tab_file,'|c ');  % First column aligned left
for i=2:nc
    fprintf(tab_file,'c ');
end
fprintf(tab_file,'}\n');
% Input Rows
for i = 1:nvar
    tmp = char(VarDesc{i});
    fprintf(tab_file,[tmp ' & ']);
    % I(1) Test;
    if Results_SP_I1(i) < 0.01
        str_tmp = ['$<$ 0.01 '];;
    else
        str_tmp = [num2str(Results_SP_I1(i),'%5.2f')];
    end
    fprintf(tab_file,[str_tmp ' & ']);
    % I(0) Test;
    if Results_SP_I0(i) < 0.01
         str_tmp = ['$<$ 0.01 '];;
    else
        str_tmp = [num2str(Results_SP_I0(i),'%5.2f')];
    end
    fprintf(tab_file,[str_tmp ' & ']);
    % Half Life
    str_tmp1 = ['[' num2str(Results_hl_ci(i,1),'%5.2f') ','];
    if Results_hl_ci(i,2) < 100
        str_tmp2 = [num2str(Results_hl_ci(i,2),'%5.2f') ']'];
    else
        str_tmp2 = ['$\\infty$ ]'];
    end
    fprintf(tab_file,[str_tmp1 str_tmp2 ' & ']);
    % OLS
    fprintf(tab_file,'%5.2f & ',Results_OLS_R2(i));
    fprintf(tab_file,'%5.2f [%5.2f,%5.2f] & ',Results_OLS_Cluster(i,[1 3 4]));
    % OLS Resid I(1) Test
    if Results_OLS_SP_I1_res(i) < 0.01
        str_tmp = ['$<$ 0.01 '];;
    else
        str_tmp = [num2str(Results_OLS_SP_I1_res(i),'%5.2f')];
    end
    fprintf(tab_file,[str_tmp ' & ']);
    % LBM-GLS
    fprintf(tab_file,'%5.2f & ',Results_FGLS_R2(i));
    fprintf(tab_file,'%5.2f [%5.2f,%5.2f] \\tabularnewline \n ',Results_FGLS_CSCPC(i,[1 2 3]));

end

fprintf(tab_file,'\\end{tabular} \n');


% Additional Table that Compares OLS (Cluster), FE (Cluster), and LBM-GLS (CSCPC)
% Set up the table
nc = 7;
tab_file = fopen([outdir 'Table_OLS_FE_LBMGLS.tex'],'w');
fprintf(tab_file,'\\begin{tabular}{ ');
fprintf(tab_file,'|c ');  % First column aligned left
for i=2:nc
    fprintf(tab_file,'c ');
end
fprintf(tab_file,'}\n');
% Input Rows
for i = 1:nvar
    tmp = char(VarDesc{i});
    fprintf(tab_file,[tmp ' & ']);
    % OLS
    fprintf(tab_file,'%5.2f & ',Results_OLS_R2(i));
    fprintf(tab_file,'%5.2f [%5.2f,%5.2f] & ',Results_OLS_Cluster(i,[1 3 4]));
    % FE
    fprintf(tab_file,'%5.2f & ',Results_FE_R2(i));
    fprintf(tab_file,'%5.2f [%5.2f,%5.2f] & ',Results_FE_Cluster(i,[1 3 4]));
    % LBM-GLS
    fprintf(tab_file,'%5.2f & ',Results_FGLS_R2(i));
    fprintf(tab_file,'%5.2f [%5.2f,%5.2f] \\tabularnewline \n ',Results_FGLS_CSCPC(i,[1 2 3]));

end
fprintf(tab_file,'\\end{tabular} \n');




